// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkResource;

#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

#include <ContentTools/Common/Filters/Common/Filter/hctFilterInterface.h>
#include <ContentTools/Common/Filters/Common/Filter/hctFilterDescriptor.h>

#include <ContentTools/Common/Filters/FilterTexture/CompressTexture/hctCompressTextureFilterOptions.h>

class hctCompressTextureFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctCompressTextureFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctCompressTextureFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        virtual void hideOptions();

        // filter options
        hctCompressTextureFilterOptions m_options;
        hkArray< hkStringOld > m_nameStrings;
        hkArray< hkxTextureFile* > m_listedFileTextures;
        hkArray< hkxTextureInplace* > m_listedInplaceTextures;
        hkArray< int > m_currentEditOptionIndices;

        hkRootLevelContainer* m_optionSceneData;
        hkResource* m_optionSceneDataTracker;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_getOptionsBuf;
        mutable hkArray<char> m_setOptionsBuf;

        // dialog
        HWND m_optionsDialog;
};

class hctCompressTextureFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0x1492cba7; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_GRAPHICS; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "Compress Texture"; }
        /*virtual*/ const char* getLongName() const { return "Block Compress (DXT) textures and store as DDS files. As the output is DDS, it can also create mipmaps too. Output will be inplace or file based depending on input."; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,1,1); }
        /*virtual*/ hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctCompressTextureFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctCompressTextureFilterDesc g_compressTextureDesc;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
