// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

#include <ContentTools/Common/Filters/FilterScene/hctFilterSceneDll.h>

// Filters we want to expose in this dll:
#include <ContentTools/Common/Filters/FilterScene/RemoveScale/hctRemoveScaleFilter.h>
#include <ContentTools/Common/Filters/FilterScene/SceneTransform/hctSceneTransformFilter.h>
#include <ContentTools/Common/Filters/FilterScene/AlignSceneToNode/hctAlignSceneToNodeFilter.h>
#include <ContentTools/Common/Filters/FilterScene/PlatformWriter/hctPlatformWriterFilter.h>
#include <ContentTools/Common/Filters/FilterScene/AlterMesh/hctAlterMeshFilter.h>
#include <ContentTools/Common/Filters/FilterScene/CreateTangents/hctCreateTangentsFilter.h>
#include <ContentTools/Common/Filters/FilterScene/FindInstances/hctFindInstancesFilter.h>
#include <ContentTools/Common/Filters/FilterScene/ConvertTexturesToPng/hctConvertTexturesToPNGFilter.h>
#include <ContentTools/Common/Filters/FilterScene/RemoteUpdate/hctFilterRemoteUpdate.h>
#include <ContentTools/Common/Filters/FilterScene/ExecuteCommand/hctExecuteCommandFilter.h>
#include <ContentTools/Common/Filters/FilterScene/RigidSkin/hctRigidSkinFilter.h>

__declspec( dllexport ) hctFilterDll* getFilterDll (HMODULE dllModule)
{
    static hctFilterSceneDll gFilterSceneDll (dllModule);

    return &gFilterSceneDll;
}


hctFilterSceneDll::hctFilterSceneDll (HMODULE dllModule) : hctFilterDll (dllModule)
{
}

/*virtual*/ int hctFilterSceneDll::getNumberOfFilters() const
{
    return 11;
}

/*virtual*/ hctFilterDescriptor* hctFilterSceneDll::getFilterDescriptor (int index) const
{
    static hctFilterDescriptor* m_filterDescs[] =
    {
        &g_removeScaleDesc,
        &g_sceneTransformDesc,
        &g_platformWriterDesc,
        &g_alterMeshDesc,
        &g_createTangentsDesc,
        &g_findInstancesDesc,
        &g_alignSceneToNodeDesc,
        &g_convertTexturesToPNGDesc,
        &g_remoteToolFilterDesc,
        &g_executeCommandDesc,
        &g_rigidSkinDesc,
    };

    return m_filterDescs[index];
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
