// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// Describes delta compression settings
class hctSceneTransformOptions
{
    public:

        HK_DECLARE_CLASS(hctSceneTransformOptions, New, Reflect);

            ///
        enum Preset
        {
                ///
            IDENTITY,
                ///
            MIRROR_X,
                ///
            MIRROR_Y,
                ///
            MIRROR_Z,
                ///
            SCALE_FEET_TO_METERS,
                ///
            SCALE_INCHES_TO_METERS,
                ///
            SCALE_CMS_TO_METERS,
                ///
            CUSTOM,
                ///
            MAYA_TO_VISION_ENTITY,
                ///
            MAX_TO_VISION_ENTITY,
                ///
            PRESET_MAX_ID
        };

            /// Default constructor
        hctSceneTransformOptions() { }

        //
        // Members
        //
    public:

            /// Chosen transformation preset
        hkEnum<Preset, hkInt8> m_preset; //+default(hctSceneTransformOptions::IDENTITY)

            /// Should we apply this transformation to scene graph nodes
        hkBool m_applyToNodes; //+default(true)

            /// Should we apply this transformation to vertex buffers
        hkBool m_applyToBuffers; //+default(true)

            /// Should we apply this transformation to vertex float channels
        hkBool m_applyToFloatChannels; //+default(true)

            /// Should we apply this transformation to lights
        hkBool m_applyToLights; //+default(true)

            /// Should we apply this transformation to cameras
        hkBool m_applyToCameras; //+default(true)

            /// Should we flip index buffer winding
        hkBool m_flipWinding; //+default(false)

            /// The transform to apply
        hkMatrix4 m_matrix;
};

HK_REFLECT_ENUM(/**/, hctSceneTransformOptions::Preset);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
