// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/FilterScene/SceneTransform/hctSceneTransformOptions.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>

class hctSceneTransformFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctSceneTransformFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctSceneTransformFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data  );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

    private:

        void transformResourceData(const hkxSceneUtils::SceneTransformOptions& options, class hkResourceContainer* resourceContainer);

    // Public for the dialog
    public:

        HWND m_optionsDialog;
        hkBool m_fillingControls; // True when we are setting up the data in the controls; avoids recursion
        hkBool m_doNotRefreshEdit; // To avoid the custom samples edit box being updated constantly and cursor being lost

        hctSceneTransformOptions m_options;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;

        // Dialog handling stuff
        void setControlsFromData();
        void setDataFromControls();
};

class hctSceneTransformFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0xaa786565; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_CORE; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "Transform Scene"; }
        /*virtual*/ const char* getLongName() const { return "Scene Transformation Filter"; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,2,2); }
        /*virtual*/ hctFilterInterface* createFilter(const class hctFilterManagerInterface* owner) const { return new hctSceneTransformFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctSceneTransformFilterDesc g_sceneTransformDesc;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
