// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

#include <ContentTools/Common/Filters/FilterScene/RigidSkin/hctRigidSkinFilter.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>

#include <windowsx.h>

extern HINSTANCE hInstance;

/*
static void _recursiveAddNodes( const hkxNode* node, HWND listBox, hkArray<hctRigidSkinFilter::SectionInfo>& meshNodes )
{
    if (node->m_name && node->m_object.val() && node->m_object.getClass())
    {
        hkxMesh* m = hkxSceneUtils::getMeshFromNode( node );
        if (m)
        {
            for (int s=0; s < m->m_sections.getSize(); ++s)
            {
                hkStringBuf str(node->m_name.cString());
                if ( m->m_sections.getSize() > 1)
                {
                    str.printf("%s [section%d]", node->m_name.cString(), s);
                }
                else
                {
                    str = node->m_name.cString();
                }

                int pos = (int)ListBox_AddString(listBox, (LPARAM) str.cString() );

                ListBox_SetItemData(listBox, pos, (LPARAM)meshNodes.getSize() );

                hctRigidSkinFilter::SectionInfo& si = meshNodes.expandOne();
                si.m_node = node;
                si.m_sectionIndex = s;
            }
        }

    }

    for (int c=0; c < node->m_children.getSize(); ++c)
    {
        _recursiveAddNodes( node->m_children[c], listBox, meshNodes );
    }
}

static int _findNodeInSpec( const char* name, int sectionIndex, hkArray<hctRigidSkinOptions::PerMeshReorder>& triangleReorderSpec)
{
    for (int i=0; i < triangleReorderSpec.getSize(); ++i)
    {
        if ((triangleReorderSpec[i].m_sectionIndex == sectionIndex) && (hkString::strCmp(triangleReorderSpec[i].m_nodeName.cString(), name) == 0) )
        {
            return i;
        }
    }

    return -1;
}
*/

INT_PTR CALLBACK hkFilterRigidSkinDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctRigidSkinFilter* filter = reinterpret_cast<hctRigidSkinFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filter = (hctRigidSkinFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            //CheckDlgButton(hWnd, IDC_REMOVE_INDICES, filter->m_options.m_removeIndices);

            // Initialize Tool Tips
            {
            //  CreateToolTip(IDC_REMOVE_INDICES, hWnd, hInstance, "If enabled, this filter removes triangle indices from meshes, and rewrites the vertex position data using a triplet for each triangle. This is useful for rendering engines and platforms that do not support triangle indices.");
            }

            //const hkxScene* scenePtr = filter->m_dialogScene->findObject<const hkxScene>();
            /*
      HWND meshWnd = GetDlgItem(hWnd, IDC_REORDER_MESH_LIST);
            if (scenePtr && scenePtr->m_rootNode)
            {
                _recursiveAddNodes( scenePtr->m_rootNode, meshWnd, filter->m_dialogMeshNodes  );
            }

            ListBox_SetCurSel(meshWnd, 0);
          */
            return TRUE; // did handle it
        }


        case WM_COMMAND: // UI Changes
        {
            //HWND triSelWnd = GetDlgItem(hWnd, IDC_REORDER_TRISEL_LIST);
            //HWND meshWnd = GetDlgItem(hWnd, IDC_REORDER_MESH_LIST);
            //switch ( LOWORD( wParam ) )
            break;
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}

HWND hctRigidSkinFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
        hideOptions();

    m_dialogScene = getFilterManager()->getOriginalContents();

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_RIGID_SKIN_DIALOG),
        owner, hkFilterRigidSkinDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctRigidSkinFilter::updateOptions()
{
    if (m_optionsDialog)
    {
        //m_options.m_removeIndices = IsDlgButtonChecked(m_optionsDialog, IDC_REMOVE_INDICES) == TRUE;
    }
}

void hctRigidSkinFilter::hideOptions()
{
    updateOptions();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
