// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>
#include <ContentTools/Common/Filters/FilterScene/RigidSkin/hctRigidSkinFilter.h>

#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Container/PointerMap/hkMap.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/Channels/hkxTriangleSelectionChannel.h>
#include <Common/SceneData/Mesh/Channels/hkxEdgeSelectionChannel.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>
#include <Common/Base/Math/Matrix/hkMatrix4Util.h>

hctRigidSkinFilterDesc g_rigidSkinDesc;

hctRigidSkinFilter::hctRigidSkinFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL)
{

}

hctRigidSkinFilter::~hctRigidSkinFilter()
{

}

void hctRigidSkinFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctRigidSkinOptions* options = hctFilterUtils::getNativeOptions<hctRigidSkinOptions>(optVar))
    {
        m_options = *options;
        delete options;
    }
}

void hctRigidSkinFilter::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

static void _findMeshNodes(hkxNode* n, const hkMatrix4& parentWorldTransform, hkArray<hkxNode*>& a, hkArray<hkMatrix4>& wt)
{
  hkMatrix4 thisWorldTransform; thisWorldTransform.setMul(parentWorldTransform, n->m_keyFrames[0]);

  hkxMesh* m = hkxSceneUtils::getMeshFromNode(n);
  if (m)
  {
    a.pushBack(n);
    wt.pushBack(thisWorldTransform);
  }

  for (int c=0; c < n->m_children.getSize(); ++c)
  {
    _findMeshNodes(n->m_children[c], thisWorldTransform, a, wt);
  }
}

void hctRigidSkinFilter::process( hkRootLevelContainer& data )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    if ( (scenePtr == HK_NULL) || (scenePtr->m_rootNode == HK_NULL) )
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }

    // Go through all hkxNode, any with a hkxMesh attached get merged together added as a skin binding with the orig hkxNode as the bone
  hkArray<hkxNode*> nodes;
  hkArray<hkMatrix4> nodeWT;
  hkArray<hkMatrix4> nodeLocalSpace;

  _findMeshNodes( scenePtr->m_rootNode, hkMatrix4::getIdentity(), nodes, nodeWT );

  if (nodes.getSize() < 1)
  {
    HK_WARN_ALWAYS(0xabbaa5f0, "No mesh data found");
        return;
  }

  // Merged mesh
  hkxMesh* rigidMesh = new hkxMesh();

  hkxMesh* firstMesh = hkxSceneUtils::getMeshFromNode(nodes[0]);

  // Format dependant on first mesh used
  hkxVertexDescription vertDescWithSkinningReq;
  bool eightBitIndices = nodes.getSize() < 256;
  vertDescWithSkinningReq.m_decls.append( firstMesh->m_sections[0]->m_vertexBuffer->getVertexDesc().m_decls );
  {
    vertDescWithSkinningReq.m_decls.pushBack( hkxVertexDescription::ElementDecl(hkxVertexDescription::HKX_DU_BLENDWEIGHTS, hkxVertexDescription::HKX_DT_UINT8, 4) );
    if(eightBitIndices) // 8 bit bones ids ok
        {
            vertDescWithSkinningReq.m_decls.pushBack( hkxVertexDescription::ElementDecl(hkxVertexDescription::HKX_DU_BLENDINDICES, hkxVertexDescription::HKX_DT_UINT8, 4) );
        }
        else
        {
            vertDescWithSkinningReq.m_decls.pushBack( hkxVertexDescription::ElementDecl(hkxVertexDescription::HKX_DU_BLENDINDICES, hkxVertexDescription::HKX_DT_INT16, 4) );
        }
  }

  // Material dependant on first mat in first section
  const hkxMaterial* mat = firstMesh->m_sections[0]->m_material;

  hkxMeshSection* rigidSection = new hkxMeshSection();
  rigidSection->m_material = const_cast<hkxMaterial*>( mat );
  rigidMesh->m_sections.pushBack( rigidSection );
  rigidSection->removeReference();

  int totalNumVerts = 0;
  int totalNumIndices = 0;
  nodeLocalSpace.setSize(nodes.getSize());
  hkMatrix4 worldToSkin; worldToSkin.setInverse( nodeWT[0], hkSimdReal::fromFloat(0.00001f) );

  for (int vi=0; vi < nodes.getSize(); ++vi)
  {
     hkxMesh* m = hkxSceneUtils::getMeshFromNode(nodes[vi]);
     for (int s=0; s < m->m_sections.getSize(); ++s)
     {
        totalNumVerts += m->m_sections[s]->m_vertexBuffer->getNumVertices();
        for (int i=0; i < m->m_sections[s]->m_indexBuffers.getSize(); ++i)
        {
          totalNumIndices += m->m_sections[s]->m_indexBuffers[i]->m_length;
        }
     }

     if (vi > 0)
     {
       nodeLocalSpace[vi].setMul(worldToSkin, nodeWT[vi]);
     }
     else
     {
       nodeLocalSpace[vi].setIdentity();
     }
  }

  hkxIndexBuffer* rigidIndices = new hkxIndexBuffer();
  rigidIndices->m_indexType = hkxIndexBuffer::INDEX_TYPE_TRI_LIST;
  rigidIndices->m_vertexBaseOffset = 0;
  rigidIndices->m_length = totalNumIndices;
  //xx does not handle non indexed  or non tri list etc
  if (totalNumVerts > 65535)
  {
     rigidIndices->m_indices32.setSize(totalNumIndices);
  }
  else
  {
     rigidIndices->m_indices16.setSize(totalNumIndices);
  }
  rigidSection->m_indexBuffers.pushBack( rigidIndices );
  rigidIndices->removeReference();

  hkxVertexBuffer* rigidVerts = new hkxVertexBuffer();
  rigidVerts->setNumVertices( totalNumVerts, vertDescWithSkinningReq );
  const hkxVertexDescription& vertDescWithSkinningActual = rigidVerts->getVertexDesc();
  const hkxVertexDescription::ElementDecl* wDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_BLENDWEIGHTS, 0);
  const hkxVertexDescription::ElementDecl* iDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_BLENDINDICES, 0);

  const hkxVertexDescription::ElementDecl* pDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_POSITION, 0);
  const hkxVertexDescription::ElementDecl* nDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_NORMAL, 0);
  const hkxVertexDescription::ElementDecl* tDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_TANGENT, 0);
  const hkxVertexDescription::ElementDecl* bDecl = vertDescWithSkinningActual.getElementDecl( hkxVertexDescription::HKX_DU_BINORMAL, 0);



  rigidSection->m_vertexBuffer = rigidVerts;
  rigidVerts->removeReference();

  int curIndexOffset = 0;
  int curVertexOffset = 0;
  for (int vi=0; vi < nodes.getSize(); ++vi)
  {
     hkxMesh* m = hkxSceneUtils::getMeshFromNode(nodes[vi]);
     for (int s=0; s < m->m_sections.getSize(); ++s)
     {
         for (int i=0; i < m->m_sections[s]->m_indexBuffers.getSize(); ++i)
         {
            const hkxIndexBuffer* ib = m->m_sections[s]->m_indexBuffers[i];
            if ( (ib->m_indices16.getSize() > 0) && (rigidIndices->m_indices16.getSize() > 0) )
            {
              for (int ci=0; ci < ib->m_indices16.getSize(); ++ci)
              {
                rigidIndices->m_indices16[curIndexOffset++] = ib->m_indices16[ci] + (hkUint16)curVertexOffset;
              }
            }
            else if ( (ib->m_indices32.getSize() > 0) && (rigidIndices->m_indices32.getSize() > 0) )
            {
              for (int ci=0;  ci < ib->m_indices32.getSize(); ++ci)
              {
                rigidIndices->m_indices32[curIndexOffset++] = ib->m_indices32[ci] + curVertexOffset;
              }
            }
            else // format conversion
            {
              HK_ASSERT_NO_MSG(0x688f0736, ib->m_indices16.getSize());// assume up convert only
              for (int ci=0; ci < ib->m_indices16.getSize(); ++ci)
              {
                rigidIndices->m_indices32[curIndexOffset++] = (hkUint32)(ib->m_indices16[ci]) + curVertexOffset;
              }
            }
         }

         for (int vii=0; vii< m->m_sections[s]->m_vertexBuffer->getNumVertices(); ++vii)
         {
           int cv = curVertexOffset++;
           rigidVerts->copyVertex( *(m->m_sections[s]->m_vertexBuffer), vii, cv );

           // Transform to local space of new mesh
           hkVector4* pp = (hkVector4*) ( (hkUint8*)rigidVerts->getVertexDataPtr( *pDecl ) + (pDecl->m_byteStride*cv) );
           nodeLocalSpace[vi].transformPosition(*pp, *pp);
           if (nDecl)
           {
             hkVector4* np = (hkVector4*) ( (hkUint8*)rigidVerts->getVertexDataPtr( *nDecl ) + (nDecl->m_byteStride*cv) );
             nodeLocalSpace[vi].transformDirection(*np, *np);
           }
           if (tDecl)
           {
             hkVector4* tp = (hkVector4*) ( (hkUint8*)rigidVerts->getVertexDataPtr( *tDecl ) + (tDecl->m_byteStride*cv) );
             nodeLocalSpace[vi].transformDirection(*tp, *tp);
           }
           if (bDecl)
           {
             hkVector4* bp = (hkVector4*) ( (hkUint8*)rigidVerts->getVertexDataPtr( *bDecl ) + (bDecl->m_byteStride*cv) );
             nodeLocalSpace[vi].transformDirection(*bp, *bp);
           }


           hkUint8* wp = (hkUint8*)rigidVerts->getVertexDataPtr(*wDecl) + (wDecl->m_byteStride*cv);
           wp[0] = 255; wp[1] = 0; wp[2] = 0; wp[3] = 0;
           hkUint8* wi = (hkUint8*)rigidVerts->getVertexDataPtr(*iDecl) + (iDecl->m_byteStride*cv);
           if ( eightBitIndices )
           {
             wi[0] = (hkUint8)vi; wi[1] = 0; wi[2] = 0; wi[3] = 0;
           }
           else
           {
             hkUint16* wii = ( hkUint16* ) wi;
             wii[0] = (hkUint8)vi; wii[1] = 0; wii[2] = 0; wii[3] = 0;
           }
         }
     }
  }


  // Skin
  hkxSkinBinding* rigidSkin = new hkxSkinBinding();
  rigidSkin->m_mesh = rigidMesh;
  rigidMesh->removeReference();

  int numBones = nodes.getSize();
  rigidSkin->m_nodeNames.setSize(numBones);
  rigidSkin->m_bindPose.setSize(numBones);
  for (int ai=0; ai < numBones; ++ai)
  {
    rigidSkin->m_nodeNames[ai] = nodes[ai]->m_name;
    rigidSkin->m_bindPose[ai] = nodeWT[ai];
  }
  rigidSkin->m_initSkinTransform = nodeWT[0];


  // Replace meshes
  scenePtr->m_meshes.setSize(1);
  scenePtr->m_meshes[0] = rigidMesh;
  scenePtr->m_skinBindings.setSize(1);
  scenePtr->m_skinBindings[0] = rigidSkin;

  // Node ptrs
  nodes[0]->m_object.set( rigidSkin );
  rigidSkin->removeReference();

  for (int nn=1; nn < nodes.getSize(); ++nn)
  {
    nodes[nn]->m_object.set(HK_NULL, HK_NULL);
  }

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
