// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Options/hctFilterRemoteUpdateOptions.h>

class hctFilterToolStubRemote : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctFilterToolStubRemote(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctFilterToolStubRemote();

        /*
        ** From hctFilterInterface
        */

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

        // public for the dialog
    public:


        void updateOptions();

        hkStringOld m_connectAddrStorage;
        hctFilterToolStubRemoteOptions m_options;

        // A buffer for storing the options in XML form during read / write
        mutable hkArray<char> m_optionsBuf;

        HWND m_ownerWindow;
        class hkRootLevelContainer* m_currentContainer;

        HWND m_optionsDialog;
};

class hctFilterToolStubRemoteDesc : public hctFilterDescriptor
{
    public:

        virtual unsigned int getID() const { return 0x700030cc; }
        virtual FilterCategory getCategory() const { return HK_CATEGORY_GRAPHICS; }
        virtual FilterBehaviour getFilterBehaviour() const { return HK_DATA_PASSTHRU; }
        virtual const char* getShortName() const { return "Remote Preview Update"; }
        virtual const char* getLongName() const { return "Use this filter to update a currently running Havok Preview Tool."; }
        virtual unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,2,1); }
        virtual hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctFilterToolStubRemote(owner); }
        virtual HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctFilterToolStubRemoteDesc g_remoteToolFilterDesc;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
