// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

// Windows.h, hkbase etc:
#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <Common/Serialize/Util/hkSerializeUtil.h>

#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/OArchive/hkOArchive.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>

#include <tchar.h>

#include <ContentTools/Common/Filters/Common/Options/hctFilterRemoteUpdateOptions.h>
#include <ContentTools/Common/Filters/FilterScene/RemoteUpdate/hctFilterRemoteUpdate.h>
#include <ContentTools/Common/Filters/FilterScene/resource.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.scene.remoteupdate"
#include <Common/Base/System/Log/hkLog.hxx>


hctFilterToolStubRemoteDesc g_remoteToolFilterDesc;

hctFilterToolStubRemote::hctFilterToolStubRemote(const hctFilterManagerInterface* owner)
:   hctFilterInterface(owner), m_ownerWindow(HK_NULL), m_currentContainer(HK_NULL), m_optionsDialog(HK_NULL)
{
    m_options.m_reconnectAttempts = 5;
    m_options.m_sleepTimeInMs = 20;
    m_options.m_allowAutoLaunch = true;
    m_options.m_connectAddr = "localhost";
    m_options.m_connectPort = 25010;
}

hctFilterToolStubRemote::~hctFilterToolStubRemote()
{

}

/*virtual*/ void hctFilterToolStubRemote::process ( hkRootLevelContainer& contents )
{
    hctFilterManagerInterface::ProcessMode mode = getFilterManager()->getProcessMode();
    if ( /*(mode == hctFilterManagerInterface::PROCESS_BATCH) ||*/ (mode == hctFilterManagerInterface::OPTIONS_BATCH))
    {
        return;
    }

    m_currentContainer = &contents;

    m_ownerWindow = m_filterManager->getOwnerWindowHandle();
    // XX user selected option to enable auto launch

    //..Won't see normal hkError output as error != filter error as this as in a modeless filter dll
    hkError* filterErrorHandler = (hkError*)( const_cast<hctFilterManagerInterface*>( getFilterManager() )->getErrorHandler()  );
    hkError* localError = HK_NULL;
    if (hkError::isInitialised())
    {
        localError = &hkError::getInstance();
    }
    if (filterErrorHandler)
    {
        if (localError) localError->addReference();
        hkError::replaceInstance(filterErrorHandler);
    }

    hctFilterUtils::remoteUpdateTool(contents, m_options, HCT_PREVIEW_TOOL_FILENAME);


    // Cleanup..

    if (filterErrorHandler)
    {
        filterErrorHandler->addReference();
        hkError::replaceInstance(localError); // takes the ref
    }
}

void hctFilterToolStubRemote::setOptions(const hkReflect::Var& optVar)
{
    if (hctFilterToolStubRemoteOptions* options = hctFilterUtils::getNativeOptions<hctFilterToolStubRemoteOptions>(optVar))
    {
        m_connectAddrStorage = options->m_connectAddr; // copy
        m_options = *options; // copy
        m_options.m_connectAddr = m_connectAddrStorage.cString();
        delete options;
    }
}

void hctFilterToolStubRemote::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

BOOL CALLBACK hkManagedPreviewFilterRemoteDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern HINSTANCE hInstance;
HWND hctFilterToolStubRemote::showOptions ( HWND owner )
{
    if (m_optionsDialog)
        hideOptions();

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_REMOTEUPDATEOPTIONS),
        owner, (DLGPROC)hkManagedPreviewFilterRemoteDialogProc, (LPARAM)this );

    return m_optionsDialog;
}

void hctFilterToolStubRemote::hideOptions ()
{
    if (m_optionsDialog)
    {
        // get options
        char buf[1024];
        GetWindowTextA(GetDlgItem(m_optionsDialog, IDC_EDIT_IPADDR), buf, 1023 );
        buf[1023] = 0;
        m_connectAddrStorage = buf;
        m_options.m_connectAddr = m_connectAddrStorage.cString();

        GetWindowTextA(GetDlgItem(m_optionsDialog, IDC_EDIT_PORT), buf, 1023 );
        buf[1023] = 0;
        long val = atol( buf );
        hkMath::clamp<long>(val, 0, 100000);
        m_options.m_connectPort = val;

        GetWindowTextA(GetDlgItem(m_optionsDialog, IDC_EDIT_ATTEMPTS), buf, 1023 );
        buf[1023] = 0;
        val = atol( buf );
        hkMath::clamp<long>(val, 0, 50);
        m_options.m_reconnectAttempts = val;

        GetWindowTextA(GetDlgItem(m_optionsDialog, IDC_EDIT_TIMEOUT), buf, 1023 );
        buf[1023] = 0;
        val = atol( buf );
        hkMath::clamp<long>(val, 0, 1000);
        m_options.m_sleepTimeInMs = val;

        m_options.m_allowAutoLaunch = IsDlgButtonChecked( m_optionsDialog, IDC_CHECK_LAUNCH ) != 0;

        DestroyWindow(m_optionsDialog);
    }
    m_optionsDialog = NULL;
}


BOOL CALLBACK hkManagedPreviewFilterRemoteDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctFilterToolStubRemote* previewToolFilter = reinterpret_cast<hctFilterToolStubRemote*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch(message)
    {
    case WM_INITDIALOG:
        {
            previewToolFilter = (hctFilterToolStubRemote*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            // Init options:
            SetWindowTextA(GetDlgItem(hWnd, IDC_EDIT_IPADDR), previewToolFilter->m_options.m_connectAddr);
            hkStringOld num;
            num.printf("%d", previewToolFilter->m_options.m_connectPort);
            SetWindowTextA(GetDlgItem(hWnd, IDC_EDIT_PORT), num.cString() );
            num.printf("%d", previewToolFilter->m_options.m_reconnectAttempts);
            SetWindowTextA(GetDlgItem(hWnd, IDC_EDIT_ATTEMPTS), num.cString() );
            num.printf("%d", previewToolFilter->m_options.m_sleepTimeInMs);
            SetWindowTextA(GetDlgItem(hWnd, IDC_EDIT_TIMEOUT), num.cString() );

            CheckDlgButton( hWnd, IDC_CHECK_LAUNCH, previewToolFilter->m_options.m_allowAutoLaunch? 1 : 0 );

        }
        return TRUE; // did handle it

    case WM_COMMAND:
        {
        //  switch ( LOWORD(wParam) )
            break;
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
