// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Options/hctPlatformWriterOptions.h>

// Short name
typedef hctPlatformWriterOptions OPTTYPE;

class hctPlatformWriterFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctPlatformWriterFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctPlatformWriterFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

        /*virtual*/ void getFileDependencies(const class hkRootLevelContainer& data, hkArray<hkStringPtr>& filesOut);


    public:
        void updateOptions();
        HWND m_optionsDialog;

        mutable hkStringOld m_assetFolder;
        mutable hkStringOld m_filename;

        mutable hctPlatformWriterOptions m_options;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;



};

// Version history
// 1.0.1 oldest
// 1.1.0 added "m_tagfile"
// 1.2.0 added "m_textFormat" / removed XML from packfile options

class hctPlatformWriterFilterDesc : public hctFilterDescriptor
{
    public:

        enum { FILTER_ID = 0xab787565, };
        /*virtual*/ unsigned int getID() const { return (unsigned int)FILTER_ID; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_CORE; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_EXTERNAL; }
        /*virtual*/ const char* getShortName() const { return "Write to Platform"; }
        /*virtual*/ const char* getLongName() const { return "Write binary or text (XML) data for any given platform."; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,2,0); }
        /*virtual*/ hctFilterInterface* createFilter(const class hctFilterManagerInterface* owner) const { return new hctPlatformWriterFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctPlatformWriterFilterDesc g_platformWriterDesc;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
