// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

#include <ContentTools/Common/Filters/FilterScene/PlatformWriter/hctPlatformWriterFilter.h>

#include <Common/SceneData/Scene/hkxSceneUtils.h>

#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Base/Config/hkConfigVersion.h>
#include <Common/Base/Reflect/Builder/hkTypeCopier.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>

#include <Common/SceneData/Graph/hkxNode.h>

#include <Common/SceneData/Environment/hkxEnvironment.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.scene.platformwriter"
#include <Common/Base/System/Log/hkLog.hxx>


hctPlatformWriterFilterDesc g_platformWriterDesc;

hctPlatformWriterFilter::hctPlatformWriterFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL)
{
}

hctPlatformWriterFilter::~hctPlatformWriterFilter()
{
}

void hctPlatformWriterFilter::process( class hkRootLevelContainer& data )
{
    hctFilterUtils::writeToPlatform(data, m_filename, m_options);
}

// process() is in the Dialog cpp so as to make use of the static lookup tables etc.

void hctPlatformWriterFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctPlatformWriterOptions* options = hctFilterUtils::getNativeOptions<hctPlatformWriterOptions>(optVar))
    {
        m_filename = options->m_filename;
        m_options = *options;
        delete options;
    }
}

void hctPlatformWriterFilter::getOptions(hkReflect::Any& buffer) const
{
    m_options.m_filename = (char*) m_filename.cString(); // so that the ptr is valid
    buffer.setFromObj( m_options );
}

void hctPlatformWriterFilter::getFileDependencies(const hkRootLevelContainer& data, hkArray<hkStringPtr>& filesOut)
{
    // This code is based on hctFilterUtils::writeToPlatform()
    {

        // Find the environment in the root level container
        hkxEnvironment tempEnvironment;
        hkxEnvironment* environmentPtr = HK_NULL;
        bool prunedEnvironment = false;
        {
            environmentPtr = data.findObject<hkxEnvironment>();

            // If no environemnt is found, use a temporary one
            if (!environmentPtr)
            {
                prunedEnvironment = true;
                environmentPtr = &tempEnvironment;

                // If we have a scene, fill the environment with ti
                hkxScene* scenePtr = data.findObject<hkxScene>();
                if (scenePtr)
                {
                    hkxSceneUtils::fillEnvironmentFromScene(*scenePtr, tempEnvironment);
                }
            }
        }

        hkStringBuf fileName(m_filename.cString());

        if (fileName.isEmpty())
        {
            fileName = ".\\$(asset)_$(configuration).hkx";
        }

        hkStringOld userFilename;
        const bool substitutionOk = hctFilterUtils::replaceVariables(*environmentPtr, fileName.cString(), userFilename, true);

        if (!substitutionOk && prunedEnvironment)
        {
            HK_WARN_ALWAYS(0xabba9a9f, "No environment data (required for variable substitutions) found - possibly pruned.");
        }

        // Construct the full filename if the path seems to be relative
        hkStringOld fullFilename;
        hctFilterUtils::getFullPath(data, userFilename.cString(), fullFilename);

        if (fullFilename.getLength() > 0)
        {
            filesOut.pushBack( hkStringPtr(fullFilename.cString()) );
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
