// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>
#include <ContentTools/Common/Filters/FilterScene/ExecuteCommand/hctExecuteCommandFilter.h>

#include <Common/Base/Container/String/hkUtf8.h>

#include <shlwapi.h>
#include <tchar.h>
#include <stdio.h>


extern HINSTANCE hInstance;


struct _FilterInfo
{
    hctExecuteCommandFilter* m_filter;
    const hkRootLevelContainer* m_originalContents;
};

INT_PTR CALLBACK hkFilterExecuteCommandDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    _FilterInfo* filterInfo = reinterpret_cast<_FilterInfo*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA));

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filterInfo = (_FilterInfo*)lParam;
            HK_ASSERT_NO_MSG(0x7ff5fb91, filterInfo);
            HK_ASSERT_NO_MSG(0x6dd976d0, filterInfo->m_filter);
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later
            filterInfo->m_filter->m_optionsDialog = hWnd;

            EnableWindow(GetDlgItem(hWnd, IDC_RE_COMMANDLIST), true);

            hctExecuteCommandOptions& filterOptions = filterInfo->m_filter->m_options;
            SetDlgItemTextW(hWnd, IDC_RE_COMMANDLIST, hkUtf8::WideFromUtf8(filterOptions.m_commands));

            // Initialize Tool Tips
            {
                CreateToolTip(IDC_RE_COMMANDLIST, hWnd, hInstance, "This acts like the command line prompt allowing you to specify multiple commands. Defined environment variables can be used.");
            }

            return TRUE; // did handle it
        }
        case WM_COMMAND: // UI Changes
        {
            HK_ASSERT_NO_MSG(0x1540aec0, filterInfo);
            HK_ASSERT_NO_MSG(0x4d4640b7, filterInfo->m_filter);
            hctExecuteCommandOptions& filterOptions = filterInfo->m_filter->m_options;


            switch (LOWORD(wParam))
            {
                case IDC_RE_COMMANDLIST:
                {
                    hctGetDlgItemHkStringPtr(hWnd, IDC_RE_COMMANDLIST, filterOptions.m_commands);
                    break;
                }
            }
            break;
        }
        case WM_DESTROY:
        {
            if (filterInfo) delete filterInfo;
            break;
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}


HWND hctExecuteCommandFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
        hideOptions();

    // Try to guess where is the "main" folder for the asset, from the environment or scene data objects
    hctFilterUtils::getAssetFolder(*m_filterManager->getOriginalContents(), m_assetFolder);

    _FilterInfo* fi = new _FilterInfo;
    fi->m_originalContents = getFilterManager()->getOriginalContents();
    fi->m_filter = this;

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_EXECUTE_COMMAND_DIALOG),
        owner, hkFilterExecuteCommandDialogProc, (LPARAM) fi );

    return m_optionsDialog;

}

void hctExecuteCommandFilter::updateOptions()
{
    if (m_optionsDialog)
    {
        hctGetDlgItemHkStringPtr(m_optionsDialog, IDC_RE_COMMANDLIST, m_commands);
        m_options.m_commands = m_commands;
    }
}

void hctExecuteCommandFilter::hideOptions()
{
    updateOptions();
    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }
    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
