// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

#include <ContentTools/Common/Filters/FilterScene/ExecuteCommand/hctExecuteCommandFilter.h>
#include <ContentTools/Common/Filters/FilterScene/ExecuteCommand/hctExecuteCommandOptions.h>

#include <Common/SceneData/Scene/hkxSceneUtils.h>

#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Base/Container/String/hkUtf8.h>

#include <Common/SceneData/Graph/hkxNode.h>

#include <Common/SceneData/Environment/hkxEnvironment.h>
#include <Common/Base/Config/hkConfigVersion.h>

#include <stdio.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.scene.executecmd"
#include <Common/Base/System/Log/hkLog.hxx>


hctExecuteCommandFilterDesc g_executeCommandDesc;



hctExecuteCommandFilter::hctExecuteCommandFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL)
{
}

hctExecuteCommandFilter::~hctExecuteCommandFilter()
{
}


void hctExecuteCommandFilter::process( class hkRootLevelContainer& data )
{
    // Find the environment in the root level container
    hkxEnvironment tempEnvironment;
    hkxEnvironment* environmentPtr = HK_NULL;
    bool prunedEnvironment = false;
    {
        environmentPtr = data.findObject<hkxEnvironment>();

        // If no environment is found, use a temporary one
        if (!environmentPtr)
        {
            prunedEnvironment = true;
            environmentPtr = &tempEnvironment;

            // If we have a scene, fill the environment with ti
            hkxScene* scenePtr = data.findObject<hkxScene>();
            if (scenePtr)
            {
                hkxSceneUtils::fillEnvironmentFromScene(*scenePtr, tempEnvironment);
            }
        }
    }

    // Handle commands
    if( m_commands.getLength() > 0 )
    {
        hkStringOld userCommandList;

        // Substitute environment variables
        const bool substitutionOk = hctFilterUtils::replaceVariables(*environmentPtr, m_commands.cString(), userCommandList, true );

        if (!substitutionOk && prunedEnvironment)
        {
            HK_WARN_ALWAYS(0xabba9a9f, "No environment data (required for variable substitutions) found - possibly pruned.");
        }

        //
        // Go through the userCommandList and execute commands
        //
        {
            //
            // Fix the user command list
            //
            {
                //replaces "\n" with "&" (see Using multiple commands and conditional processing symbols)
                userCommandList.replaceInplace("\n", " & ", hkString::REPLACE_ALL);

                const hkArray<char> &chars = userCommandList.getArray();

                int end = userCommandList.getLength() - 1;

                //Gets rid of any carriage returns and '&' at the end, otherwise output to the console will be incorrect
                while( (chars[end] == '&') || (chars[end] == '\r') ||  (chars[end] == ' ') )
                {
                    end--;
                }
                userCommandList = userCommandList.substr(0, (end + 1) );

                // Redirect STDERR to STDOUT with 2>&1
                userCommandList += " 2>&1";
            }

            //
            // Run commands so that it writes its output to a pipe. Open this pipe with read text attribute so that we can read it like a text file.
            //
            FILE *fp = _wpopen(hkUtf8::WideFromUtf8(userCommandList.cString()), L"rt");
            if (fp)
            {
                hkStringOld commandLineOutput;
                char inChar;

                //
                // Do a byte read of the file ... some output contains binary 0s e.g. "fsutil fsinfo drives" returns output with embedded binary 0s.
                //
                {
                    inChar = char(fgetc(fp));
                    //int i = 0;

                    while(!feof(fp) && inChar != 0xffffffff)
                    {
                        commandLineOutput += hkStringOld(&inChar);
                        inChar = char(fgetc(fp));
                    }
                }

                //
                // Report the console output: maximum output is 512 characters
                //
                {
                    hkStringOld subString;
                    {
                        const int maxChars = 512;
                        int index = 0;
                        while(index < commandLineOutput.getLength())
                        {
                            subString = commandLineOutput.substr(index, maxChars);
                            Log_Info( subString.cString() );
                            index += maxChars;
                        }
                    }
                }

                //Close pipe and print return value
                int pipeError = _pclose(fp);
                if(pipeError != 0)
                {
                    hkStringOld errorMsg;
                    errorMsg.printf("Problem with command: error %d", pipeError);
                    HK_WARN_ALWAYS(0xabba9a9f, errorMsg.cString());
                }
            }
        }
    }
    else
    {
        HK_WARN_ALWAYS( 0xabba4323, "No commands to process." );
    }

}


// process() is in the Dialog cpp so as to make use of the static lookup tables etc.

void hctExecuteCommandFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctExecuteCommandOptions* options = hctFilterUtils::getNativeOptions<hctExecuteCommandOptions>(optVar))
    {
        m_options = *options; // copy the main part.
        hctFilterUtils::emptyIfNull(m_options.m_commands);
        m_commands = m_options.m_commands;
        delete options;
    }
}

void hctExecuteCommandFilter::getOptions(hkReflect::Any& buffer) const
{
    m_options.m_commands = m_commands; // so that the ptr is valid
    buffer.setFromObj( m_options );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
