// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>

#include <ContentTools/Common/Filters/FilterScene/CreateTangents/hctCreateTangentsFilter.h>
#include <ContentTools/Common/Filters/FilterScene/CreateTangents/hctCreateTangentsOptions.h>

#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>

#include <ContentTools/Common/Filters/Common/Utils/hctFilterUtils.h>

#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

#include <Common/SceneData/Mesh/hkxMeshSectionUtil.h>

hctCreateTangentsFilterDesc g_createTangentsDesc;

hctCreateTangentsFilter::hctCreateTangentsFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL),
    m_splitVertices(true),
    m_ignoreUnlit(true)
{
}

hctCreateTangentsFilter::~hctCreateTangentsFilter()
{

}


hkxNode* _findFirstNodeRef( hkxNode* n, void* obj ); // defined the dialog cpp

static bool _isUnlit( const char* userProps)
{
    return hkString::strStr(userProps, "UNLIT") != HK_NULL;
}

void hctCreateTangentsFilter::process( hkRootLevelContainer& data )
{

    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    hkxScene& scene = *scenePtr;


    // Find all meshes, and for those selected to be converted, add tangents and bi-tangents (aka bi-normals)
    for (int i=0; i < scene.m_meshes.getSize(); ++i)
    {
        hkxMesh* mesh = scene.m_meshes[i];
        hkxNode* node = _findFirstNodeRef( scene.m_rootNode, mesh );

        if ( m_meshList.getSize() > 0 )
        {
            if (!node || !(node->m_name))
            {
                continue;
            }

            int j=0;
            for (; j < m_meshList.getSize(); ++j)
            {
                if (hkString::strCmp( node->m_name, m_meshList[j].cString()) == 0 )
                {
                    break; // found
                }
            }

            if (j == m_meshList.getSize())
            {
                continue; // !found
            }
        }

        // Any node that is marked as UNLIT does not require any tangents
        if ( m_ignoreUnlit && node )
        {
            const char* userProps = node->m_userProperties;
            if (userProps && _isUnlit(userProps))
            {
                continue;
            }
        }

    hkxMeshSectionUtil::computeTangents( mesh, m_splitVertices, node? node->m_name : HK_NULL );
    }
}

void hctCreateTangentsFilter::setOptions( const hkReflect::Var& optVar )
{
    if (hctCreateTangentsOptions* options = hctFilterUtils::getNativeOptions<hctCreateTangentsOptions>(optVar))
    {
        m_splitVertices = options->m_splitVertices;
        m_ignoreUnlit = options->m_ignoreUnlit;

        // Set up the array of meshes to generate tangents and binormals for.
        hctFilterUtils::createArrayFromDelimitedString( m_meshList, options->m_meshes, ';' );

        delete options;
    }
}

void hctCreateTangentsFilter::getOptions(hkReflect::Any& buffer) const
{
    hctCreateTangentsOptions options;

    hkStringOld allMeshes;
    for ( int i = 0; i < m_meshList.getSize(); ++i )
    {
        allMeshes += m_meshList[i];
        allMeshes += ";";
    }
    options.m_meshes = const_cast<char*>( allMeshes.cString() );
    options.m_splitVertices = m_splitVertices;
    options.m_ignoreUnlit = m_ignoreUnlit;

    buffer.setFromObj( options );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
