// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>
#include <ContentTools/Common/Filters/FilterScene/ConvertTexturesToPng/hctConvertTexturesToPNGFilter.h>

extern HINSTANCE hInstance;

INT_PTR CALLBACK hkFilterTexturesToPNGDialogProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    hctConvertTexturesToPNGFilter* filter = reinterpret_cast<hctConvertTexturesToPNGFilter*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch( message )
    {
        case WM_INITDIALOG:
        {
            filter = (hctConvertTexturesToPNGFilter*)lParam;
            SetWindowLongPtr( hWnd, GWLP_USERDATA, (LONG_PTR)lParam ); // so that it can be retrieved later

            // Set the check boxes
            CheckDlgButton( hWnd, IDC_RESIZE_ENABLE, filter->m_options.m_enable );
            EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_U_VALUE ), filter->m_options.m_enable );
            EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_V_VALUE ), filter->m_options.m_enable );

            if( filter->m_options.m_u == 0 )
            {
                SetDlgItemText( hWnd, IDC_RESIZE_U_VALUE, "0" );
                SetDlgItemText( hWnd, IDC_RESIZE_V_VALUE, "0" );
            }

            else
            {
                SetDlgItemInt( hWnd, IDC_RESIZE_U_VALUE, filter->m_options.m_u, true );
                SetDlgItemInt( hWnd, IDC_RESIZE_V_VALUE, filter->m_options.m_v, true );
            }

            // Initialize Tool Tips
            {
                CreateToolTip(IDC_RESIZE_ENABLE, hWnd, hInstance, "If enabled, the filter will also resize any converted texture to the given size.");
                CreateToolTip(IDC_RESIZE_U_VALUE, hWnd, hInstance, "This value sets the number of texels in the u axis.");
                CreateToolTip(IDC_RESIZE_V_VALUE, hWnd, hInstance, "This value sets the number of texels in the v axis.");
            }

            return TRUE; // did handle it
        }

        case WM_COMMAND: // UI Changes
        {
            switch ( LOWORD( wParam ) )
            {
                case IDC_RESIZE_ENABLE:
                {
                    if( IsDlgButtonChecked( hWnd, IDC_RESIZE_ENABLE ) == TRUE )
                    {
                        filter->m_options.m_enable = true;

                        SetDlgItemInt( hWnd, IDC_RESIZE_U_VALUE, filter->m_options.m_u, true );
                        EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_U_VALUE ), TRUE);

                        SetDlgItemInt( hWnd, IDC_RESIZE_V_VALUE, filter->m_options.m_v, true );
                        EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_V_VALUE ), TRUE );
                    }

                    else
                    {
                        filter->m_options.m_enable = false;

                        EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_U_VALUE ), FALSE );
                        EnableWindow( GetDlgItem( hWnd,IDC_RESIZE_V_VALUE ), FALSE );
                    }

                    break;
                }

            }
        }

        default:
        {
            return FALSE;   //didn't handle it / didn't do much with it
        }

    }
}

HWND hctConvertTexturesToPNGFilter::showOptions( HWND owner)
{
    if( m_optionsDialog )
    {
        hideOptions();
    }

    m_optionsDialog = CreateDialogParamW( hInstance, MAKEINTRESOURCEW( IDD_CONVERTPNG_DIALOG ),
        owner, hkFilterTexturesToPNGDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctConvertTexturesToPNGFilter::updateOptions()
{
    if( m_optionsDialog )
    {
        if( IsDlgButtonChecked(m_optionsDialog, IDC_RESIZE_ENABLE) == TRUE )
        {
            m_options.m_u = static_cast<hkInt16>(hctGetDlgItemInt(m_optionsDialog, IDC_RESIZE_U_VALUE));
            if( m_options.m_u < 0 )
            {
                m_options.m_u = 1;
                SetDlgItemText( m_optionsDialog, IDC_RESIZE_U_VALUE, "1" );
            }

            m_options.m_v = static_cast<hkInt16>(hctGetDlgItemInt(m_optionsDialog, IDC_RESIZE_V_VALUE));
            if( m_options.m_v < 0 )
            {
                m_options.m_v = 1;
                SetDlgItemText( m_optionsDialog, IDC_RESIZE_V_VALUE, "1" );
            }
        }
    }
}

void hctConvertTexturesToPNGFilter::hideOptions()
{
    updateOptions();

    if( m_optionsDialog )
    {
        DestroyWindow( m_optionsDialog );
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
