// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// Options describing what to do to any meshes found.
class hctAlterMeshOptions
{
    public:

        HK_DECLARE_CLASS(hctAlterMeshOptions, New, Reflect, BypassCtor);

            /// Default constructor
        hctAlterMeshOptions() { }

        struct PerMeshReorder
        {
            HK_DECLARE_CLASS(PerMeshReorder, New, Reflect, BypassCtor);

            PerMeshReorder() {}
            PerMeshReorder(const PerMeshReorder& rhs)
                : m_nodeName(rhs.m_nodeName)
                , m_sectionIndex(rhs.m_sectionIndex)
            {
                m_triangleSelections = rhs.m_triangleSelections;
            }

            hkStringPtr m_nodeName; // mesh owner node name
            int m_sectionIndex;
            hkArray< hkStringPtr > m_triangleSelections; // an in order list of the names of the triangle selections to use to reorder with.
        };

        //
        // Members
        //
    public:

            /// Remove indices from the meshes (unroll into the vertex buffer)
        hkBool m_removeIndices; //+default(false)

        hkArray< struct PerMeshReorder > m_triangleReorderSpec;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
