// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>
#include <ContentTools/Common/Filters/FilterScene/AlterMesh/hctAlterMeshFilter.h>

#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Container/PointerMap/hkMap.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/Channels/hkxTriangleSelectionChannel.h>
#include <Common/SceneData/Mesh/Channels/hkxEdgeSelectionChannel.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>

hctAlterMeshFilterDesc g_alterMeshDesc;

hctAlterMeshFilter::hctAlterMeshFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL)
{
    m_options.m_removeIndices = false;
}

hctAlterMeshFilter::~hctAlterMeshFilter()
{

}

void hctAlterMeshFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctAlterMeshOptions* options = hctFilterUtils::getNativeOptions<hctAlterMeshOptions>(optVar))
    {
        m_options = *options;
        delete options;
    }
}

void hctAlterMeshFilter::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

inline hkInt16 _getIndex16( hkxIndexBuffer* ib, int i )
{
    return (hkInt16)(ib->m_vertexBaseOffset + ( ib->m_indices16.getSize() > 0? ib->m_indices16[i] : i ));
}

inline hkInt32 _getIndex32( hkxIndexBuffer* ib, int i )
{
    return (hkInt32)(ib->m_vertexBaseOffset + ( ib->m_indices32.getSize() > 0? ib->m_indices32[i] : i ));
}

static int _findUserChannel( hkArray< hkRefPtr<hkxMesh::UserChannelInfo> >& u, const char* name )
{
    for (int i=0; i < u.getSize(); ++i)
    {
        if ( (hkString::strCmp( u[i]->m_name.cString(), name) == 0) && ( hkString::strCmp(u[i]->m_className.cString(), "hkxTriangleSelectionChannel") == 0))
        {
            return i;
        }
    }
    return -1;
}

void hctAlterMeshFilter::process( hkRootLevelContainer& data )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    hkxScene& scene = *scenePtr;

    // Remove Index Buffers
    // It removes the indices, but leaves the index buffer as they contain the triangle storage (list, strip, etc)
    // so become an offset into the vb instead of a buffer itself.
    if (m_options.m_removeIndices || (m_options.m_triangleReorderSpec.getSize() > 0) )
    {
        hkArray<hkxMesh*> reorderMesh;
        hkArray<int> reorderMeshInfoIndex;

        for (int s=0; s < m_options.m_triangleReorderSpec.getSize(); ++s)
        {
            hkStringPtr& nodeName = m_options.m_triangleReorderSpec[s].m_nodeName;
            const hkxNode* n = scene.findNodeByName(nodeName.cString());
            if (n)
            {
                hkxMesh* m = hkxSceneUtils::getMeshFromNode( n );
                if (m)
                {
                    reorderMesh.pushBack(m);
                    reorderMeshInfoIndex.pushBack(s);
                }
            }
        }


        for (int i=0; i < scene.m_meshes.getSize(); ++i)
        {
            hkxMesh* curMesh = scene.m_meshes[i];
            // Do reorder before index removal
            int reorderIdx = reorderMesh.indexOf(curMesh);
            while (reorderIdx >= 0)
            {
                const hctAlterMeshOptions::PerMeshReorder& ro = m_options.m_triangleReorderSpec[ reorderMeshInfoIndex[reorderIdx] ];
                hkxMeshSection* section = curMesh->m_sections[ro.m_sectionIndex];
                if (section->m_indexBuffers.getSize() == 1)
                {
                    hkPointerMap<hkInt32, hkInt32> doneTris;
                    const hkxIndexBuffer* curIndexBuffer = section->m_indexBuffers[0];
                    if (curIndexBuffer->m_indexType != hkxIndexBuffer::INDEX_TYPE_TRI_LIST)
                    {
                        HK_WARN_ALWAYS(0xabba0000, "Non trilist mesh under " << ro.m_nodeName << ", will not reorder");
                    }
                    else if ((curIndexBuffer->m_indices16.getSize() == 0) && (curIndexBuffer->m_indices32.getSize() == 0))
                    {
                        HK_WARN_ALWAYS(0xabba0000, "Non indexed mesh under " << ro.m_nodeName << ", will not reorder");
                    }
                    else // Single trilist, indexed: can add more cases above if u like, butall other cases uncommon on export
                    {
                        hkxIndexBuffer* newIndexBuffer = new hkxIndexBuffer;
                        newIndexBuffer->m_indexType = hkxIndexBuffer::INDEX_TYPE_TRI_LIST;
                        newIndexBuffer->m_vertexBaseOffset = curIndexBuffer->m_vertexBaseOffset;
                        newIndexBuffer->m_length = curIndexBuffer->m_length;
                        newIndexBuffer->m_indices16.setSize( curIndexBuffer->m_indices16.getSize() );
                        newIndexBuffer->m_indices32.setSize( curIndexBuffer->m_indices32.getSize() );

                        int destTri = 0;
                        hkArray<int> doneChannels;
                        for (int si = 0; si < ro.m_triangleSelections.getSize(); ++si)
                        {
                            int channelNum = _findUserChannel( curMesh->m_userChannelInfos, ro.m_triangleSelections[si].cString() );
                            if (channelNum >= 0)
                            {
                                doneChannels.pushBack(channelNum);
                                hkxTriangleSelectionChannel* sel = (hkxTriangleSelectionChannel*)section->m_userChannels[channelNum].val(); // should be safe as would not be here otherwise..
                                hkArray<hkInt32>& triIndices = sel->m_selectedTriangles;
                                if (curIndexBuffer->m_indices16.getSize() > 0)
                                {
                                    for (int ti=0; ti < triIndices.getSize(); ++ti)
                                    {
                                        hkInt32 sourceTri = triIndices[ti];
                                        triIndices[ti] = destTri;// Alter the selection too
                                        doneTris.insert(sourceTri, destTri);

                                        newIndexBuffer->m_indices16[destTri*3] = curIndexBuffer->m_indices16[sourceTri*3];
                                        newIndexBuffer->m_indices16[(destTri*3) + 1] = curIndexBuffer->m_indices16[(sourceTri*3) + 1];
                                        newIndexBuffer->m_indices16[(destTri*3) + 2] = curIndexBuffer->m_indices16[(sourceTri*3) + 2];
                                        ++destTri;

                                    }
                                }
                                else
                                {
                                    for (int ti=0; ti < triIndices.getSize(); ++ti)
                                    {
                                        hkInt32 sourceTri = triIndices[ti];
                                        triIndices[ti] = destTri;// Alter the selection too   XX Edgeselections influenced too..
                                        doneTris.insert(sourceTri, destTri);

                                        newIndexBuffer->m_indices32[destTri*3] = curIndexBuffer->m_indices32[sourceTri*3];
                                        newIndexBuffer->m_indices32[(destTri*3) + 1] = curIndexBuffer->m_indices32[(sourceTri*3) + 1];
                                        newIndexBuffer->m_indices32[(destTri*3) + 2] = curIndexBuffer->m_indices32[(sourceTri*3) + 2];
                                        ++destTri;

                                    }
                                }
                            }
                        }

                        // rest at end
                        int totalNumTris = (newIndexBuffer->m_length / 3);
                        if (doneTris.getSize() < totalNumTris)
                        {
                            if (newIndexBuffer->m_indices32.getSize() > 0)
                            {
                                for (int ti=0; ti < totalNumTris; ++ti)
                                {
                                    if ( doneTris.getWithDefault(ti, -1) < 0 )
                                    {
                                        doneTris.insert(ti, destTri);

                                        newIndexBuffer->m_indices32[destTri*3] = curIndexBuffer->m_indices32[ti*3];
                                        newIndexBuffer->m_indices32[(destTri*3) + 1] = curIndexBuffer->m_indices32[(ti*3) + 1];
                                        newIndexBuffer->m_indices32[(destTri*3) + 2] = curIndexBuffer->m_indices32[(ti*3) + 2];
                                        ++destTri;
                                    }
                                }
                            }
                            else
                            {
                                for (int ti=0; ti < totalNumTris; ++ti)
                                {
                                    if ( doneTris.getWithDefault(ti, -1) < 0 )
                                    {
                                        doneTris.insert(ti, destTri);

                                        newIndexBuffer->m_indices16[destTri*3] = curIndexBuffer->m_indices16[ti*3];
                                        newIndexBuffer->m_indices16[(destTri*3) + 1] = curIndexBuffer->m_indices16[(ti*3) + 1];
                                        newIndexBuffer->m_indices16[(destTri*3) + 2] = curIndexBuffer->m_indices16[(ti*3) + 2];
                                        ++destTri;
                                    }
                                }
                            }
                        }

                        // using the doneTris map we should alter all other trisels and edge sels on this section
                        for (int chi=0; chi < curMesh->m_userChannelInfos.getSize(); ++chi)
                        {
                            if (doneChannels.indexOf(chi) >= 0)
                                continue; // already reindexed etc above

                            if ( hkString::strCmp(curMesh->m_userChannelInfos[chi]->m_className.cString(), "hkxTriangleSelectionChannel") == 0)
                            {
                                hkxTriangleSelectionChannel* ch = (hkxTriangleSelectionChannel*)section->m_userChannels[chi].val();
                                for (int ii=0; ii < ch->m_selectedTriangles.getSize(); ++ii)
                                {
                                     ch->m_selectedTriangles[ii] = doneTris.getWithDefault( ch->m_selectedTriangles[ii], 0 );
                                }
                            }
                            else if ( hkString::strCmp(curMesh->m_userChannelInfos[chi]->m_className.cString(), "hkxEdgeSelectionChannel") == 0)
                            {
                                hkxEdgeSelectionChannel* ch = (hkxEdgeSelectionChannel*)section->m_userChannels[chi].val();
                                for (int ii=0; ii < ch->m_selectedEdges.getSize(); ++ii)
                                {
                                    int tri = ch->m_selectedEdges[ii] / 3; // tri*3 + edgenum, so /3 with round down == tri index
                                    int newTri = doneTris.getWithDefault( tri, 0 );
                                    int offset = newTri - tri;
                                    ch->m_selectedEdges[ii] += (offset * 3);
                                }
                            }
                        }

                        section->m_indexBuffers[0] = newIndexBuffer; // takes a ref
                        newIndexBuffer->removeReference();
                    }
                }
                else
                {
                    HK_WARN_ALWAYS(0xabba0000, "Non standard mesh under " << ro.m_nodeName << ", will not reorder");
                }


                // next section (if any)
                reorderIdx = reorderMesh.indexOf(curMesh, reorderIdx + 1, -1);
            }

            if (m_options.m_removeIndices)
            {
                for (int j=0; j < curMesh->m_sections.getSize(); ++j)
                {
                    hkxMeshSection* section = curMesh->m_sections[j];
                    hkxVertexBuffer* origVB = section->m_vertexBuffer;
                    if (!origVB) continue; // dodgy

                    int unwoundVerts = 0;
                    bool trivialBuffers = true;
                    int ib;
                    for (ib=0; ib < section->m_indexBuffers.getSize(); ++ib)
                    {
                        unwoundVerts += section->m_indexBuffers[ib]->m_length;
                        trivialBuffers = trivialBuffers && (section->m_indexBuffers[ib]->m_indices16.getSize() == 0) && (section->m_indexBuffers[ib]->m_indices32.getSize() == 0);
                    }

                    if (trivialBuffers || (unwoundVerts < 1)) // all tivial (no actual indices) or no buffers at all
                        continue; // next section

                    // allocate enough space for all the verts
                    hkxVertexBuffer* newVb = new hkxVertexBuffer();
                    newVb->setNumVertices( unwoundVerts, origVB->getVertexDesc() );

                    int curVertex = 0;
                    int curVertexIndex = 0;
                    for (ib=0; ib < section->m_indexBuffers.getSize(); ++ib)
                    {
                        hkxIndexBuffer* indexBuf = section->m_indexBuffers[ib];
                        bool sixteenBit = indexBuf->m_indices16.getSize() > 0;
                        unsigned int numI = section->m_indexBuffers[ib]->m_length;
                        for (hkUint32 ci=0; ci < numI; ++ci)
                        {
                            int fromIdx = sixteenBit? _getIndex16(indexBuf, ci) : _getIndex32(indexBuf, ci);
                            newVb->copyVertex( *origVB, fromIdx, curVertex++); // copy the vert
                        }

                        indexBuf->m_vertexBaseOffset = curVertexIndex;
                        curVertexIndex += numI;
                        indexBuf->m_indices16.setSize(0);
                        indexBuf->m_indices32.setSize(0);
                    }

                    // set the vb ptrs
                    section->m_vertexBuffer = newVb;
                    newVb->removeReference();
                }
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
