// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterScene/hctFilterScene.h>
#include <ContentTools/Common/Filters/FilterScene/AlignSceneToNode/hctAlignSceneToNodeFilter.h>
#include <Common/SceneData/Graph/hkxNode.h>

#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Serialize/Resource/hkResource.h>
extern HINSTANCE hInstance;


void hctAlignSceneToNodeFilter::setDataFromControls()
{
    m_options.m_invert =             !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_INVERT );
    m_options.m_transformPositionX = !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_X );
    m_options.m_transformPositionY = !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_Y );
    m_options.m_transformPositionZ = !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_Z );
    m_options.m_transformRotation =  !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_ROTATION );
    m_options.m_transformScale =     !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_SCALE );
    m_options.m_transformSkew =      !!IsDlgButtonChecked( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_SKEW );

    {
        hkStringPtr str;
        hctGetDlgItemHkStringPtr(m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_PICK_EDIT, str);
        m_options.setNodeName(str);
    }

    {
        m_options.m_keyframe = hctGetDlgItemInt(m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_KEYFRAME_EDIT);
    }

    // Update controls again
    setControlsFromData();
}

void hctAlignSceneToNodeFilter::setControlsFromData()
{
    m_fillingControls = true;

    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_INVERT, m_options.m_invert );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_X, m_options.m_transformPositionX );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_Y, m_options.m_transformPositionY );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_POSITION_Z, m_options.m_transformPositionZ );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_ROTATION, m_options.m_transformRotation );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_SCALE, m_options.m_transformScale );
    CheckDlgButton( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_SKEW, m_options.m_transformSkew );

    if ( !m_doNotRefreshEdit )
    {
        SetDlgItemTextW( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_PICK_EDIT, hkUtf8::WideFromUtf8(m_options.getNodeName()) );

        hkStringOld tmp;
        tmp.printf( "%d", m_options.m_keyframe );

        SetDlgItemText( m_optionsDialog, IDC_ALIGN_SCENE_TO_NODE_KEYFRAME_EDIT, tmp.cString() );
    }

    m_fillingControls = false;
}

struct hkFilterAlignSceneToNodeDialogProcInfo
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_EXPORT, hkFilterAlignSceneToNodeDialogProcInfo );

    hkFilterAlignSceneToNodeDialogProcInfo( hctAlignSceneToNodeFilter* f, const hctFilterManagerInterface* m )
    {
        m_filter = f;
        m_filterManager = m;
    }

    hctAlignSceneToNodeFilter* m_filter;
    const hctFilterManagerInterface *m_filterManager;
};


INT_PTR CALLBACK hkFilterAlignSceneToNodeDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hkFilterAlignSceneToNodeDialogProcInfo* filterDataInfo = reinterpret_cast< hkFilterAlignSceneToNodeDialogProcInfo* > ( (hkUlong) GetWindowLongPtr( hWnd,GWLP_USERDATA ) );

    switch(message)
    {
        case WM_INITDIALOG:
        {
            hkFilterAlignSceneToNodeDialogProcInfo* data = (hkFilterAlignSceneToNodeDialogProcInfo*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            data->m_filter->m_optionsDialog = hWnd;

            // Init options
            data->m_filter->setControlsFromData();

            return TRUE; // did handle it
        }
        case WM_DESTROY:
            {
                delete filterDataInfo;
                break;
            }
        case WM_COMMAND: // UI Changes
        {
            // Avoid recursion
            if (!filterDataInfo->m_filter->m_fillingControls)
            {
                switch ( LOWORD(wParam) )
                {
                case IDC_ALIGN_SCENE_TO_NODE_PICK_EDIT:
                case IDC_ALIGN_SCENE_TO_NODE_KEYFRAME_EDIT:
                    filterDataInfo->m_filter->m_doNotRefreshEdit = true;
                }
                filterDataInfo->m_filter->setDataFromControls();
                filterDataInfo->m_filter->m_doNotRefreshEdit = false;
            }


            switch ( LOWORD(wParam) )
            {
            case IDC_ALIGN_SCENE_TO_NODE_PICK_BUTTON:
                {
                    hkRootLevelContainer* container = HK_NULL;
                    hkResource* packfileData = HK_NULL;
                    filterDataInfo->m_filterManager->getInputContentsToCurrentFilter( &container, packfileData);

                    // Need a scene root
                    hkVariant rootNodeVar;
                    {
                        hkxScene* scene = container->findObject<hkxScene>();
                        if( !scene || !scene->m_rootNode )
                        {
                            break;
                        }
                        rootNodeVar = scene->m_rootNode.val();
                    }

                    // Bring up selection dialog, using our tree view manager
                    hkVariant selected;
                    hctDefaultTreeViewManager tvManager( &rootNodeVar );
                    if( !filterDataInfo->m_filterManager->selectObjectFromTree( hWnd, "Select Node", &tvManager, selected ) )
                    {
                        break;  // cancelled
                    }

                    const hkxNode* node = hkReflect::exactMatchDynCast<hkxNode>(selected);
                    HK_ASSERT_NO_MSG(0x6f695219, node);

                    // Set the name of the reference node
                    filterDataInfo->m_filter->m_options.setNodeName( node->m_name );
                    filterDataInfo->m_filter->setControlsFromData();

                    packfileData->removeReference();
                }
            }
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}

HWND hctAlignSceneToNodeFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
        hideOptions();

    // New'd as it is a modless dlg. Will be deleted on destroy.
    hkFilterAlignSceneToNodeDialogProcInfo* data = new hkFilterAlignSceneToNodeDialogProcInfo( this, m_filterManager );

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_ALIGN_SCENE_TO_NODE_DIALOG),
        owner, hkFilterAlignSceneToNodeDialogProc, (LPARAM) data );

    return m_optionsDialog;
}


void hctAlignSceneToNodeFilter::hideOptions()
{
    //setDataFromControls();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
