// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Filter/hctFilterInterface.h>
#include <ContentTools/Common/Filters/Common/Filter/hctFilterDescriptor.h>
#include <ContentTools/Common/Filters/FilterScene/AlignSceneToNode/hctAlignSceneToNodeOptions.h>
#include <ContentTools/Common/Filters/FilterScene/AlignSceneToNode/hctAlignSceneToNodeFilter.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>

/// This class is a duplicate of hkAlignSceneToNodeOptions.h.
/// Please do not change one without changing the other.
/// For further information, please refer to EXP-1655 and EXP-1656

class hctAlignSceneToNodeFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctAlignSceneToNodeFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctAlignSceneToNodeFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

    // Public for the dialog
    public:

        HWND m_optionsDialog;
        hkBool m_fillingControls; // True when we are setting up the data in the controls; avoids recursion
        hkBool m_doNotRefreshEdit; // To avoid the custom samples edit box being updated constantly and cursor being lost

        hctAlignSceneToNodeOptions m_options;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;

        // Dialog handling stuff
        void setControlsFromData();
        void setDataFromControls();

    private:
        // Similarity transform: result = T^-1 M T
        static void HK_CALL similarity( hkMatrix4& result, const hkMatrix4& T, const hkMatrix4& M );
};

class hctAlignSceneToNodeFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0x5010d60b; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_CORE; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "Align Scene To Node"; }
        /*virtual*/ const char* getLongName() const { return "Align Scene To Node Filter"; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,0,1); }
        /*virtual*/ hctFilterInterface* createFilter(const class hctFilterManagerInterface* owner) const { return new hctAlignSceneToNodeFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctAlignSceneToNodeFilterDesc g_alignSceneToNodeDesc;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
