// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysicsDll.h>

// REGISTER ALL COMPLETE CLASSES
#define HK_FEATURE_REFLECTION_PHYSICS_2012
#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses 
#define HK_CLASSES_FILE <Common/Base/ClassLists/hkClassLists.cxx>
#include <Common/Base/Config/hkProductFeatures.h>
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#include <Common/Base/Config/hkProductFeatures.cxx>

// Filters we want to expose in this dll:
#include <ContentTools/Common/Filters/FilterPhysics2012/CreateRigidBodies/hctCreateRigidBodiesFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/CreateConstraints/hctCreateConstraintsFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/CreateConstraintChains/hctCreateConstraintChainsFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/CreateWorld/hctCreateWorldFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/ShrinkShapes/hctShrinkShapesFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/SetRadius/hctSetRadiusFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/OptimizeShapeHierarchy/hctOptimizeShapeHierarchyFilter.h>

#include <Physics2012/Collide/Util/Welding/hkpWeldingUtility.h>
#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>

__declspec( dllexport ) hctFilterDll* getFilterDll (HMODULE dllModule)
{
    static hctFilterPhysics2012Dll gFilterDynamicsDll (dllModule);

    return &gFilterDynamicsDll;
}


hctFilterPhysics2012Dll::hctFilterPhysics2012Dll (HMODULE dllModule) : hctFilterDll (dllModule)
{
}

/*virtual*/ int hctFilterPhysics2012Dll::getNumberOfFilters() const
{
    return 7;
}

/*virtual*/ hctFilterDescriptor* hctFilterPhysics2012Dll::getFilterDescriptor (int index) const
{
    static hctFilterDescriptor* m_filterDescs[] =
    {
        &g_createRigidBodiesDesc,
        &g_createConstraintsDesc,
        &g_createWorldDesc,
        &g_createConstraintChainsDesc,
        &g_shrinkDesc,
        &g_setRadiusDesc,
        &g_optimizeShapeHierarchyDesc,
    };

    return m_filterDescs[index];
}

/*virtual*/ void hctFilterPhysics2012Dll::initDll ( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream )
{
    hctFilterDll::initDll(baseSystemInfo, errorStream);

    // HVK-3632
    if (isInitialized())
    {
        hkpWorldCinfo defaults;
        hkpWeldingUtility::initWeldingTable(defaults.m_snapCollisionToConvexEdgeThreshold, defaults.m_snapCollisionToConcaveEdgeThreshold);
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
