// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#if 0
R\
"exclude1(";
R"exclude2()exclude1";
#endif

#pragma once

#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define UNPACK_OPT_PARAM(...) __VA_ARGS__
#if defined(HK_FILTER_REFLECT_OPT)
#   undef HK_FILTER_REFLECT_OPT
#endif
#if defined(HK_EXCLUDE_FROM_DATA_REFLECTION)
#   undef HK_EXCLUDE_FROM_DATA_REFLECTION
#endif
#if defined(HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION)
#   undef HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION
#endif
#if defined(HK_REFLECT_TYPE_DATA_ONLY)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_ONLY_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x)
#elif defined(HK_REFLECT_TYPE_CONSTRUCTABLE)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_CONSTRUCTIBLE_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#else
#   define HK_FILTER_REFLECT_OPT(x) (x)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x) UNPACK_OPT_PARAM x
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#endif

#include <ContentTools/Common/Filters/FilterPhysics2012/CreateRigidBodies/hctCreateRigidBodiesOptions.h>


struct hctCreateRigidBodiesOptions::_Auto
{    
    struct m_bestFittingShapes { static const hkReflect::Detail::TypeData typeData;};
    struct m_mergeMeshDuplicates { static const hkReflect::Detail::TypeData typeData;};
    struct m_wrapWithMopp { static const hkReflect::Detail::TypeData typeData;};
    struct m_listShapesMoppThreshold { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableMoppChunks { static const hkReflect::Detail::TypeData typeData;};
    struct m_spuOptimizedMopps { static const hkReflect::Detail::TypeData typeData;};
    struct m_spuOptimizedConvex { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_landscapeWelding(const void* valuePtr) { const decltype(hctCreateRigidBodiesOptions::m_landscapeWelding)& fieldValue = *reinterpret_cast<const decltype(hctCreateRigidBodiesOptions::m_landscapeWelding)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_landscapeWelding { static const hkReflect::Detail::TypeData typeData;};
    struct m_weldOpenEdges { static const hkReflect::Detail::TypeData typeData;};
    struct m_weldAcrossAllMopps { static const hkReflect::Detail::TypeData typeData;};
    struct m_markEdgesBadWinding { static const hkReflect::Detail::TypeData typeData;};
    struct m_collapseShapeOffsetsIntoShapes { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableAutomaticShapeShrinking { static const hkReflect::Detail::TypeData typeData;};
    struct m_defaultConvexRadius { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxVertexDisplacement { static const hkReflect::Detail::TypeData typeData;};
    struct m_relShrinkRadius { static const hkReflect::Detail::TypeData typeData;};
    struct m_quantizationError { static const hkReflect::Detail::TypeData typeData;};
    struct m_exportDestructionInformation { static const hkReflect::Detail::TypeData typeData;};
    struct m_joinOverlappingMeshMaterials { static const hkReflect::Detail::TypeData typeData;};
    struct m_materialPrefix { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_meshShapeType(const void* valuePtr) { const decltype(hctCreateRigidBodiesOptions::m_meshShapeType)& fieldValue = *reinterpret_cast<const decltype(hctCreateRigidBodiesOptions::m_meshShapeType)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_meshShapeType { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_namedMaterialSource(const void* valuePtr) { const decltype(hctCreateRigidBodiesOptions::m_namedMaterialSource)& fieldValue = *reinterpret_cast<const decltype(hctCreateRigidBodiesOptions::m_namedMaterialSource)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_namedMaterialSource { static const hkReflect::Detail::TypeData typeData;};
    struct Decls { static const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,22> decls;};
    static inline bool isValid(const hctCreateRigidBodiesOptions& value) { return isValid_m_landscapeWelding(&value.m_landscapeWelding) && isValid_m_meshShapeType(&value.m_meshShapeType) && isValid_m_namedMaterialSource(&value.m_namedMaterialSource); }
    static inline bool isValidPtr(const void* valuePtr) { return isValid(*reinterpret_cast<const hctCreateRigidBodiesOptions*>(valuePtr)); }    
};


struct hctCreateRigidBodiesOptions_LanscapeWelding_Auto
{    
    static const hctCreateRigidBodiesOptions::LanscapeWelding hkPresets_WELD_COUNTERCLOCKWISE;
    static const hctCreateRigidBodiesOptions::LanscapeWelding hkPresets_WELD_CLOCKWISE;
    static const hctCreateRigidBodiesOptions::LanscapeWelding hkPresets_WELD_TWO_SIDED;
    static const hctCreateRigidBodiesOptions::LanscapeWelding hkPresets_WELD_NONE;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> LanscapeWelding_attributes;    
};


struct hctCreateRigidBodiesOptions_MeshShapeType_Auto
{    
    static const hctCreateRigidBodiesOptions::MeshShapeType hkPresets_EXTENDED_MESH_SHAPE;
    static const hctCreateRigidBodiesOptions::MeshShapeType hkPresets_COMPRESSED_MESH_SHAPE;
    static const hctCreateRigidBodiesOptions::MeshShapeType hkPresets_SIMPLE_MESH_SHAPE;
    static const hctCreateRigidBodiesOptions::MeshShapeType hkPresets_BV_COMPRESSED_MESH_SHAPE;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> MeshShapeType_attributes;    
};


struct hctCreateRigidBodiesOptions_NamedMaterialSource_Auto
{    
    static const hctCreateRigidBodiesOptions::NamedMaterialSource hkPresets_MATERIAL_NONE;
    static const hctCreateRigidBodiesOptions::NamedMaterialSource hkPresets_MATERIAL_MESH_SECTIONS;
    static const hctCreateRigidBodiesOptions::NamedMaterialSource hkPresets_MATERIAL_TRIANGLE_SELECTIONS;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> NamedMaterialSource_attributes;    
};




#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// CXXRecord: hctCreateRigidBodiesOptions
//
#if !defined(HK_REFLECT_TYPE_DATA_ONLY)
hctCreateRigidBodiesOptions::hctCreateRigidBodiesOptions(hkReflect::BypassCtorFlag f)
{
}
#endif
hkReflect::Detail::TypeRegNode hctCreateRigidBodiesOptions_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hctCreateRigidBodiesOptions ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hctCreateRigidBodiesOptions >::Holder::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::DESTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::REFLECT_CONSTRUCTOR | hkReflect::Opt::DECLS | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfRecord::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::HavokRecordImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hctCreateRigidBodiesOptions"),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::ExplicitWrapper< hkReflect::Opt::DEF_CONSTRUCTOR, hctCreateRigidBodiesOptions >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Implicit< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DESTRUCTOR, &hkReflect::Detail::Implicit< hkReflect::Opt::DESTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Implicit< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hctCreateRigidBodiesOptions),HK_ALIGN_OF(hctCreateRigidBodiesOptions),0)),    
    HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::REFLECT_CONSTRUCTOR, hkReflect::Detail::ReflectConstructionWrapper< hctCreateRigidBodiesOptions >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECLS, reinterpret_cast<const hkReflect::Detail::DeclsArray*>(&hctCreateRigidBodiesOptions::_Auto::Decls::decls)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hctCreateRigidBodiesOptions::_Auto::isValidPtr),))    
};
const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_bestFittingShapes::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "bestFittingShapes"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_bestFittingShapes, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_mergeMeshDuplicates::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "mergeMeshDuplicates"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_mergeMeshDuplicates, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_wrapWithMopp::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "wrapWithMopp"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_wrapWithMopp, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_listShapesMoppThreshold::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "listShapesMoppThreshold"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_listShapesMoppThreshold, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_enableMoppChunks::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableMoppChunks"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableMoppChunks, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_spuOptimizedMopps::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "spuOptimizedMopps"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_spuOptimizedMopps, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_spuOptimizedConvex::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "spuOptimizedConvex"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_spuOptimizedConvex, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_landscapeWelding::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hctCreateRigidBodiesOptions::LanscapeWelding, hkReflect::Typedef::hkUint8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "landscapeWelding"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_landscapeWelding, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hctCreateRigidBodiesOptions::_Auto::isValid_m_landscapeWelding),))
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_weldOpenEdges::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "weldOpenEdges"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_weldOpenEdges, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_weldAcrossAllMopps::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "weldAcrossAllMopps"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_weldAcrossAllMopps, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_markEdgesBadWinding::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "markEdgesBadWinding"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_markEdgesBadWinding, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_collapseShapeOffsetsIntoShapes::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "collapseShapeOffsetsIntoShapes"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_collapseShapeOffsetsIntoShapes, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_enableAutomaticShapeShrinking::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableAutomaticShapeShrinking"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableAutomaticShapeShrinking, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_defaultConvexRadius::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "defaultConvexRadius"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_defaultConvexRadius, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_maxVertexDisplacement::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxVertexDisplacement"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxVertexDisplacement, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_relShrinkRadius::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "relShrinkRadius"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_relShrinkRadius, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_quantizationError::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "quantizationError"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_quantizationError, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_exportDestructionInformation::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "exportDestructionInformation"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_exportDestructionInformation, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_joinOverlappingMeshMaterials::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "joinOverlappingMeshMaterials"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_joinOverlappingMeshMaterials, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_materialPrefix::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkStringPtr ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "materialPrefix"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_materialPrefix, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_meshShapeType::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hctCreateRigidBodiesOptions::MeshShapeType, hkReflect::Typedef::hkUint8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "meshShapeType"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_meshShapeType, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hctCreateRigidBodiesOptions::_Auto::isValid_m_meshShapeType),))
};;

const hkReflect::Detail::TypeData hctCreateRigidBodiesOptions::_Auto::m_namedMaterialSource::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hctCreateRigidBodiesOptions::NamedMaterialSource, hkReflect::Typedef::hkUint8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "namedMaterialSource"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_namedMaterialSource, hctCreateRigidBodiesOptions)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hctCreateRigidBodiesOptions::_Auto::isValid_m_namedMaterialSource),))
};;

const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,22> hctCreateRigidBodiesOptions::_Auto::Decls::decls = 
{
    { 22, 0, 22, 0 }, {
        reinterpret_cast<const hkReflect::Type*>(&m_bestFittingShapes::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_mergeMeshDuplicates::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_wrapWithMopp::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_listShapesMoppThreshold::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableMoppChunks::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_spuOptimizedMopps::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_spuOptimizedConvex::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_landscapeWelding::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_weldOpenEdges::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_weldAcrossAllMopps::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_markEdgesBadWinding::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_collapseShapeOffsetsIntoShapes::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableAutomaticShapeShrinking::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_defaultConvexRadius::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxVertexDisplacement::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_relShrinkRadius::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_quantizationError::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_exportDestructionInformation::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_joinOverlappingMeshMaterials::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_materialPrefix::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_meshShapeType::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_namedMaterialSource::typeData),
 }};

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#if defined(HK_INCLUDE_VALIDATE_INLINES) || defined(HK_DETAIL_REFLECT_DEFINITIONS)
HK_REFLECT_VALIDATE_INLINE bool hctCreateRigidBodiesOptions::reflectValidate() const { return hctCreateRigidBodiesOptions::_Auto::isValid(*this); };
#endif
#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hctCreateRigidBodiesOptions::LanscapeWelding
//

hkReflect::Detail::TypeRegNode hctCreateRigidBodiesOptions_LanscapeWelding_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hctCreateRigidBodiesOptions::LanscapeWelding ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hctCreateRigidBodiesOptions::LanscapeWelding >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hctCreateRigidBodiesOptions::LanscapeWelding >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hctCreateRigidBodiesOptions::LanscapeWelding >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hctCreateRigidBodiesOptions::LanscapeWelding"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hctCreateRigidBodiesOptions_LanscapeWelding_Auto::LanscapeWelding_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hctCreateRigidBodiesOptions::LanscapeWelding),HK_ALIGN_OF(hctCreateRigidBodiesOptions::LanscapeWelding),0)),    
};
const hctCreateRigidBodiesOptions::LanscapeWelding hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_WELD_COUNTERCLOCKWISE = static_cast< hctCreateRigidBodiesOptions::LanscapeWelding >(0);

const hctCreateRigidBodiesOptions::LanscapeWelding hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_WELD_CLOCKWISE = static_cast< hctCreateRigidBodiesOptions::LanscapeWelding >(1);

const hctCreateRigidBodiesOptions::LanscapeWelding hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_WELD_TWO_SIDED = static_cast< hctCreateRigidBodiesOptions::LanscapeWelding >(2);

const hctCreateRigidBodiesOptions::LanscapeWelding hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_WELD_NONE = static_cast< hctCreateRigidBodiesOptions::LanscapeWelding >(3);

const char* const hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_names[] = {"WELD_COUNTERCLOCKWISE","WELD_CLOCKWISE","WELD_TWO_SIDED","WELD_NONE" };

const void* const hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_value[] = { &hkPresets_WELD_COUNTERCLOCKWISE, &hkPresets_WELD_CLOCKWISE, &hkPresets_WELD_TWO_SIDED, &hkPresets_WELD_NONE };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hctCreateRigidBodiesOptions_LanscapeWelding_Auto::LanscapeWelding_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::LanscapeWelding >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::LanscapeWelding >::presets = { true, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions::LanscapeWelding ), 4, hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_names, hctCreateRigidBodiesOptions_LanscapeWelding_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hctCreateRigidBodiesOptions::MeshShapeType
//

hkReflect::Detail::TypeRegNode hctCreateRigidBodiesOptions_MeshShapeType_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hctCreateRigidBodiesOptions::MeshShapeType ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hctCreateRigidBodiesOptions::MeshShapeType >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hctCreateRigidBodiesOptions::MeshShapeType >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hctCreateRigidBodiesOptions::MeshShapeType >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hctCreateRigidBodiesOptions::MeshShapeType"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hctCreateRigidBodiesOptions_MeshShapeType_Auto::MeshShapeType_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hctCreateRigidBodiesOptions::MeshShapeType),HK_ALIGN_OF(hctCreateRigidBodiesOptions::MeshShapeType),0)),    
};
const hctCreateRigidBodiesOptions::MeshShapeType hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_EXTENDED_MESH_SHAPE = static_cast< hctCreateRigidBodiesOptions::MeshShapeType >(0);

const hctCreateRigidBodiesOptions::MeshShapeType hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_COMPRESSED_MESH_SHAPE = static_cast< hctCreateRigidBodiesOptions::MeshShapeType >(1);

const hctCreateRigidBodiesOptions::MeshShapeType hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_SIMPLE_MESH_SHAPE = static_cast< hctCreateRigidBodiesOptions::MeshShapeType >(2);

const hctCreateRigidBodiesOptions::MeshShapeType hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_BV_COMPRESSED_MESH_SHAPE = static_cast< hctCreateRigidBodiesOptions::MeshShapeType >(3);

const char* const hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_names[] = {"EXTENDED_MESH_SHAPE","COMPRESSED_MESH_SHAPE","SIMPLE_MESH_SHAPE","BV_COMPRESSED_MESH_SHAPE" };

const void* const hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_value[] = { &hkPresets_EXTENDED_MESH_SHAPE, &hkPresets_COMPRESSED_MESH_SHAPE, &hkPresets_SIMPLE_MESH_SHAPE, &hkPresets_BV_COMPRESSED_MESH_SHAPE };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hctCreateRigidBodiesOptions_MeshShapeType_Auto::MeshShapeType_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::MeshShapeType >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::MeshShapeType >::presets = { true, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions::MeshShapeType ), 4, hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_names, hctCreateRigidBodiesOptions_MeshShapeType_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hctCreateRigidBodiesOptions::NamedMaterialSource
//

hkReflect::Detail::TypeRegNode hctCreateRigidBodiesOptions_NamedMaterialSource_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hctCreateRigidBodiesOptions::NamedMaterialSource ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hctCreateRigidBodiesOptions::NamedMaterialSource >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hctCreateRigidBodiesOptions::NamedMaterialSource >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hctCreateRigidBodiesOptions::NamedMaterialSource >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hctCreateRigidBodiesOptions::NamedMaterialSource"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::NamedMaterialSource_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hctCreateRigidBodiesOptions::NamedMaterialSource),HK_ALIGN_OF(hctCreateRigidBodiesOptions::NamedMaterialSource),0)),    
};
const hctCreateRigidBodiesOptions::NamedMaterialSource hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_MATERIAL_NONE = static_cast< hctCreateRigidBodiesOptions::NamedMaterialSource >(0);

const hctCreateRigidBodiesOptions::NamedMaterialSource hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_MATERIAL_MESH_SECTIONS = static_cast< hctCreateRigidBodiesOptions::NamedMaterialSource >(1);

const hctCreateRigidBodiesOptions::NamedMaterialSource hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_MATERIAL_TRIANGLE_SELECTIONS = static_cast< hctCreateRigidBodiesOptions::NamedMaterialSource >(2);

const char* const hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_names[] = {"MATERIAL_NONE","MATERIAL_MESH_SECTIONS","MATERIAL_TRIANGLE_SELECTIONS" };

const void* const hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_value[] = { &hkPresets_MATERIAL_NONE, &hkPresets_MATERIAL_MESH_SECTIONS, &hkPresets_MATERIAL_TRIANGLE_SELECTIONS };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::NamedMaterialSource_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::NamedMaterialSource >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hctCreateRigidBodiesOptions::NamedMaterialSource >::presets = { true, HK_REFLECT_GET_TYPE( hctCreateRigidBodiesOptions::NamedMaterialSource ), 3, hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_names, hctCreateRigidBodiesOptions_NamedMaterialSource_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS



#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic pop
#endif

#if 0
//)exclude2";
#endif

/*
 * Havok SDK - Generated
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
