// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// Contains a list of the texture paths to remove.
class hctShrinkShapesOptions
{
    public:

        HK_DECLARE_CLASS(hctShrinkShapesOptions, New, Reflect);

        struct DefaultStruct;

            /// Default constructor
        hctShrinkShapesOptions() { }

        //
        // Members
        //
        enum ApplyTo
        {
            APPLY_TO_ALL,
            APPLY_TO_DYNAMIC,
            APPLY_TO_FIXED
        };

            /// Whether it should apply to all, dynamic or just fixed rigid bodies
        hkEnum<ApplyTo, hkInt8> m_applyTo; //+default(hctShrinkShapesOptions::APPLY_TO_ALL)

    public:

            /// A list of the bodies not to shrink, semi colon separated
        hkStringPtr m_excludedBodies;
};

HK_REFLECT_ENUM(/**/, hctShrinkShapesOptions::ApplyTo);

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
