// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/ShrinkShapes/hctShrinkShapesFilter.h>

#include <ContentTools/Common/Filters/Common/Utils/hctFilterUtils.h>

#include <Common/SceneData/Graph/hkxNode.h>

extern HINSTANCE hInstance;

struct __MyShrinkData
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT, __MyShrinkData);
    hctShrinkShapesFilter* m_filter;

    const hkRootLevelContainer* m_originalContents;
    const hctFilterManagerInterface* m_filterManager;
};

// Tree view manager implementation
class _hkShrinkShapesTreeViewManager : public hctTreeViewManager
{
public:

    _hkShrinkShapesTreeViewManager( const hkVariant* root ) : hctTreeViewManager( root ) {}

    /*virtual*/ bool isViewable( const hkVariant& variant )
    {
        if( hkReflect::exactMatchDynCast<hkxNode>(variant) ) return true;
        return false;
    }
};

INT_PTR CALLBACK hkFilterShrinkShapesOptionsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    __MyShrinkData *data = reinterpret_cast<__MyShrinkData*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch(message)
    {
        case WM_INITDIALOG:
        {
            HWND nameWnd = GetDlgItem(hWnd, IDC_SHRINK_NAMES);
            data = (__MyShrinkData*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            // "apply to" radio buttons
            switch( data->m_filter->m_applyTo)
            {
                case hctShrinkShapesOptions::APPLY_TO_ALL:
                    CheckDlgButton( hWnd, IDC_RB_ALL_RIGID_BODIES, TRUE );
                    break;

                case hctShrinkShapesOptions::APPLY_TO_DYNAMIC:
                    CheckDlgButton( hWnd, IDC_RB_DYNAMIC_ONLY, TRUE );
                    break;

                case hctShrinkShapesOptions::APPLY_TO_FIXED:
                    CheckDlgButton( hWnd, IDC_RB_FIXED_ONLY, TRUE );
                    break;
            }


            SendMessage(nameWnd, LVM_SETEXTENDEDLISTVIEWSTYLE,0,LVS_EX_FULLROWSELECT); // Set style

            // Text item
            LVITEM LvItem;
            memset(&LvItem,0,sizeof(LvItem)); // Reset Item Struct
            LvItem.mask=LVIF_TEXT;   // Text Style
            LvItem.cchTextMax = 260; // Max size of test
            int k=0;
            for (int pi=0; pi < data->m_filter->m_excludedBodies.getSize(); ++pi)
            {
                LvItem.iItem = k++;
                LvItem.pszText = const_cast<TCHAR*>( TEXT( data->m_filter->m_excludedBodies[pi].cString() ) );
                ListView_InsertItem(nameWnd, &LvItem);
            }
        }
        return TRUE;

        case WM_COMMAND:
            switch ( LOWORD(wParam) )
            {
                case IDC_RB_ALL_RIGID_BODIES:
                    {
                        data->m_filter->m_applyTo = hctShrinkShapesOptions::APPLY_TO_ALL;
                        return TRUE;
                        break;
                    }

                case IDC_RB_DYNAMIC_ONLY:
                    {
                        data->m_filter->m_applyTo = hctShrinkShapesOptions::APPLY_TO_DYNAMIC;
                        return TRUE;
                        break;
                    }

                case IDC_RB_FIXED_ONLY:
                    {
                        data->m_filter->m_applyTo = hctShrinkShapesOptions::APPLY_TO_FIXED;
                        return TRUE;
                        break;
                    }

                case IDC_SHRINK_ADD:
                {
                    // Require a scene root
                    hkVariant rootNodeVar;
                    {
                        hkxScene* scene = data->m_filterManager->getOriginalContents()->findObject<hkxScene>();
                        if( !scene || !scene->m_rootNode )
                        {
                            break;
                        }
                        rootNodeVar = hkVariant(scene->m_rootNode.val());
                    }

                    // Bring up a selection dialog, using our tree manager
                    hkVariant selected;
                    _hkShrinkShapesTreeViewManager tvManager( &rootNodeVar);
                    if( !data->m_filterManager->selectObjectFromTree( hWnd, "Select Node", &tvManager, selected ) )
                    {
                        break;  // cancelled
                    }

                    const hkxNode* node = hkReflect::exactMatchDynCast<hkxNode>(selected);
                    HK_ASSERT_NO_MSG(0x733e4a7c, node);

                    if( node->m_name )
                    {
                        // see if we have it already
                        int idx=0;
                        for (;idx < data->m_filter->m_excludedBodies.getSize(); ++idx)
                        {
                            if (hkString::strCmp( data->m_filter->m_excludedBodies[idx].cString(), node->m_name ) == 0)
                                break;
                        }
                        if (idx == data->m_filter->m_excludedBodies.getSize())
                        {
                            data->m_filter->m_excludedBodies.pushBack(node->m_name.cString());

                            // Text item
                            HWND nodeWnd = GetDlgItem(hWnd, IDC_SHRINK_NAMES);
                            LVITEM LvItem;
                            memset(&LvItem,0,sizeof(LvItem)); // Reset Item Struct
                            LvItem.mask=LVIF_TEXT;   // Text Style
                            LvItem.cchTextMax = 260; // Max size of test
                            LvItem.iItem = ListView_GetItemCount(nodeWnd);
                            LvItem.pszText = const_cast<TCHAR*>( TEXT( node->m_name.cString() ) );
                            ListView_InsertItem(nodeWnd, &LvItem);
                        }
                    }
                }
                break;
            }
            break;

        case WM_NOTIFY:
            {
                int idCtrl = (int)wParam;
                LPNMHDR pnmh = (LPNMHDR) lParam;
                HWND nodeWnd = GetDlgItem(hWnd, IDC_SHRINK_NAMES);

                switch (idCtrl)
                {
                case IDC_SHRINK_NAMES: // list of nodes
                    {
                        switch (pnmh->code)
                        {
                        case LVN_KEYDOWN:
                            {
                                LPNMLVKEYDOWN lpnmc = (LPNMLVKEYDOWN) lParam;
                                if (VK_DELETE == lpnmc->wVKey)
                                {
                                    INT ni = ListView_GetSelectionMark( nodeWnd );
                                    while( ni >= 0 )
                                    {
                                        // reflect deletion in main list
                                        {
                                            CHAR itxt[128];
                                            ListView_GetItemText(nodeWnd, ni, 0, itxt, 128);
                                            for (int idx=0;idx < data->m_filter->m_excludedBodies.getSize(); ++idx)
                                            {
                                                if (hkString::strCmp( data->m_filter->m_excludedBodies[idx].cString(), itxt ) == 0)
                                                {
                                                    data->m_filter->m_excludedBodies.removeAt(idx);
                                                    break;
                                                }
                                            }
                                        }
                                        ListView_DeleteItem(nodeWnd, ni);
                                        ni = ListView_GetNextItem( nodeWnd, -1, LVNI_SELECTED);
                                    }
                                }
                                break;
                            }
                        case NM_CLICK:
                            {
                                SetFocus( nodeWnd);
                                return FALSE;
                            }
                        }
                    }
                    break;
                }
            }
            break;

        case WM_DESTROY:
            {
                delete data; // delete the info ptr we are using.
                break;
            }

        default:
            return FALSE;
    }
    return TRUE;
}

void hctShrinkShapesFilter::hideOptions()
{
    if (m_optionsDialog)
        DestroyWindow(m_optionsDialog);
    m_optionsDialog = NULL;
}

HWND hctShrinkShapesFilter::showOptions ( HWND owner )
{
    if (m_optionsDialog)
        hideOptions();

    __MyShrinkData* filterData = new __MyShrinkData;
    filterData->m_originalContents = getFilterManager()->getOriginalContents();
    filterData->m_filter = this;
    filterData->m_filterManager = m_filterManager;

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_SHRINK_DIALOG),
        owner, hkFilterShrinkShapesOptionsProc, (LPARAM)filterData );

    return m_optionsDialog;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
