// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/ShrinkShapes/hctShrinkShapesFilter.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/ShrinkShapes/hctShrinkShapesOptions.h>
#include <ContentTools/Common/Filters/Common/Utils/hctFilterUtils.h>

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Collide/Util/ShapeShrinker/hkpShapeShrinker.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.p12.shrinkshapes"
#include <Common/Base/System/Log/hkLog.hxx>


hctShrinkShapesFilterDesc g_shrinkDesc;

hctShrinkShapesFilter::hctShrinkShapesFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL), m_applyTo(hctShrinkShapesOptions::APPLY_TO_ALL)
{

}

hctShrinkShapesFilter::~hctShrinkShapesFilter()
{

}


void hctShrinkShapesFilter::process( hkRootLevelContainer& data )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    hkpPhysicsData* physicsPtr = data.findObject<hkpPhysicsData>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    if (physicsPtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No physics data found");
        return;
    }

    {
        hkArray<hkpShapeShrinker::ShapePair> doneShapes;
        hkArray<hkpPhysicsSystem*>& systems = const_cast<hkArray<hkpPhysicsSystem*>&>( physicsPtr->getPhysicsSystems() );
        for (int ps=0; ps < systems.getSize(); ++ps)
        {
            hkpPhysicsSystem* origSystem = systems[ps];
            // find all convex hulls that need to be shrunk
            const hkArray<hkpRigidBody*>& rbs = origSystem->getRigidBodies();
            for (int ri=0; ri < rbs.getSize(); ++ri)
            {
                hkpRigidBody* rb = rbs[ri];

                const bool isFixed = rb->isFixed();

                if (isFixed && (m_applyTo == hctShrinkShapesOptions::APPLY_TO_DYNAMIC) )
                {
                    continue;
                }

                if (!isFixed && (m_applyTo == hctShrinkShapesOptions::APPLY_TO_FIXED) )
                {
                    continue;
                }

                // see if this body is allowed
                const char* bodyName = rb->getName();
                if (bodyName)
                {
                    int rbn = 0;
                    for (; rbn < m_excludedBodies.getSize(); ++rbn)
                    {
                        if (hkString::strCmp( m_excludedBodies[rbn].cString(), bodyName)==0)
                        {
                            break; // found
                        }
                    }

                    if (rbn < m_excludedBodies.getSize())
                        continue; // next body if found
                }

                const hkpShape* s = rb->getCollidable()->getShape();
                hkpShape* newS = hkpShapeShrinker::shrinkByConvexRadius( const_cast<hkpShape*>(s), &doneShapes);
                if (newS && (newS != s))
                {
                    rb->getCollidableRw()->setShape(newS);

                    // newS->removeReference(); shape doesn't get ref'd inside collidbale, let the rb have ours
                    s->removeReference();
                }
            }
        }

        if (doneShapes.getSize()>0)
        {
            Log_Info( "{} shapes shrunk.", doneShapes.getSize() );
        }
        else
        {
            HK_WARN_ALWAYS(0xabbafa2a,"No shapes shrunk.");
        }
    }
}

void hctShrinkShapesFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctShrinkShapesOptions* options = hctFilterUtils::getNativeOptions<hctShrinkShapesOptions>(optVar))
    {
        hctFilterUtils::createArrayFromDelimitedString( m_excludedBodies, options->m_excludedBodies, ';');
        m_applyTo = options->m_applyTo;
        delete options;
    }
}

void hctShrinkShapesFilter::getOptions(hkReflect::Any& buffer) const
{
    hkStringOld singleString;
    for (int i=0; i < m_excludedBodies.getSize(); ++i)
    {
        singleString += m_excludedBodies[i];
        if ( i < (m_excludedBodies.getSize() - 1))
            singleString += ";";
    }

    hctShrinkShapesOptions options;
    options.m_excludedBodies = const_cast<char*>( singleString.cString() );
    options.m_applyTo = m_applyTo;
    buffer.setFromObj( options );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
