// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/SetRadius/hctSetRadiusFilter.h>
#include <ContentTools/Common/Filters/Common/Utils/hctLocaleScope.h>


extern HINSTANCE hInstance;

INT_PTR CALLBACK hkSetRadiusFilterDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctSetRadiusFilter* filter = reinterpret_cast<hctSetRadiusFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filter = (hctSetRadiusFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            {
                hctLocaleScope scope;

                // "radius" edit box
                hkStringOld s;
                s.printf("%f", filter->m_options.m_radius);
                SetDlgItemText(hWnd, IDC_ED_RADIUS, s.cString());
            }

            // "apply to" radio buttons
            switch( filter->m_options.m_applyTo)
            {
                case hctSetRadiusOptions::APPLY_TO_ALL:
                    CheckDlgButton( hWnd, IDC_RB_ALL_RIGID_BODIES, TRUE );
                    break;

                case hctSetRadiusOptions::APPLY_TO_DYNAMIC:
                    CheckDlgButton( hWnd, IDC_RB_DYNAMIC_ONLY, TRUE );
                    break;

                case hctSetRadiusOptions::APPLY_TO_FIXED:
                    CheckDlgButton( hWnd, IDC_RB_FIXED_ONLY, TRUE );
                    break;
            }

            return TRUE; // did handle it
        }
        case WM_COMMAND: // UI Changes
        {

            switch ( LOWORD(wParam) )
            {
                case IDC_RB_ALL_RIGID_BODIES:
                    {
                        filter->m_options.m_applyTo = hctSetRadiusOptions::APPLY_TO_ALL;
                        return TRUE;
                        break;
                    }
                case IDC_RB_DYNAMIC_ONLY:
                    {
                        filter->m_options.m_applyTo = hctSetRadiusOptions::APPLY_TO_DYNAMIC;
                        return TRUE;
                        break;
                    }
                case IDC_RB_FIXED_ONLY:
                    {
                        filter->m_options.m_applyTo = hctSetRadiusOptions::APPLY_TO_FIXED;
                        return TRUE;
                        break;
                    }
            }

        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}

HWND hctSetRadiusFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
    {
        hideOptions();
    }

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_SET_RADIUS_DIALOG),
        owner, hkSetRadiusFilterDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctSetRadiusFilter::updateOptions()
{
    if (m_optionsDialog)
    {
        hctLocaleScope scope;

        TCHAR text[256];
        GetWindowText(GetDlgItem(m_optionsDialog, IDC_ED_RADIUS), text, 256);
        m_options.m_radius = (hkReal) atof(text);

        // apply to is kept always up-to-date
    }
}

void hctSetRadiusFilter::hideOptions()
{
    updateOptions();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
