// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/SetRadius/hctSetRadiusFilter.h>

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

#include <Physics2012/Collide/Shape/Convex/Box/hkpBoxShape.h>
#include <Physics2012/Collide/Shape/Convex/Cylinder/hkpCylinderShape.h>
#include <Physics2012/Collide/Shape/Misc/Transform/hkpTransformShape.h>
#include <Physics2012/Collide/Shape/Convex/ConvexTranslate/hkpConvexTranslateShape.h>
#include <Physics2012/Collide/Shape/Convex/ConvexTransform/hkpConvexTransformShape.h>
#include <Physics2012/Collide/Shape/Misc/Bv/hkpBvShape.h>
#include <Physics2012/Collide/Shape/Compound/Tree/hkpBvTreeShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>
#include <Physics2012/Collide/Shape/Compound/Collection/List/hkpListShape.h>
#include <Physics2012/Collide/Shape/Deprecated/ConvexList/hkpConvexListShape.h>
#include <Physics2012/Collide/Shape/Convex/ConvexVertices/hkpConvexVerticesShape.h>
#include <Physics2012/Collide/Shape/Deprecated/Mesh/hkpMeshShape.h>
#include <Physics2012/Collide/Shape/Deprecated/StorageMesh/hkpStorageMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/ExtendedMeshShape/hkpExtendedMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/StorageExtendedMesh/hkpStorageExtendedMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/SimpleMesh/hkpSimpleMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>

#include <Common/Internal/ConvexHull/hkGeometryUtility.h>

hctSetRadiusFilterDesc g_setRadiusDesc;

hctSetRadiusFilter::hctSetRadiusFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner)
{
    m_options.m_radius = 0.0f;
    m_options.m_applyTo = hctSetRadiusOptions::APPLY_TO_ALL;
    m_optionsDialog = HK_NULL;
}

hctSetRadiusFilter::~hctSetRadiusFilter()
{

}

hkpShape* hctSetRadiusFilter::setRadius(hkpShape* shape, hkArray<hkpShape*>& doneShapes)
{
    if (doneShapes.indexOf(shape) >= 0)
    {
        return HK_NULL;
    }

    doneShapes.pushBack(shape);

    switch (shape->getType())
    {
        // types that have no extra radius to set
    case hkcdShapeType::SPHERE:
    case hkcdShapeType::MULTI_SPHERE:
    case hkcdShapeType::PLANE:
    case hkcdShapeType::CAPSULE:
        return HK_NULL;

        // Collections or shape wrappers
    case hkcdShapeType::CONVEX_TRANSLATE:
        {
            hkpConvexTranslateShape* ts = static_cast<hkpConvexTranslateShape*>( shape );
            ts->setRadius(m_options.m_radius);
            return setRadius( const_cast<hkpConvexShape*>(ts->getChildShape()), doneShapes);
        }
    case hkcdShapeType::CONVEX_TRANSFORM:
        {
            hkpConvexTransformShape* ts = static_cast<hkpConvexTransformShape*>( shape );
            ts->setRadius(m_options.m_radius);
            return setRadius( const_cast<hkpConvexShape*>(ts->getChildShape()), doneShapes);
        }
    case hkcdShapeType::TRANSFORM:
        {
            hkpTransformShape* ts = static_cast<hkpTransformShape*>( shape );
            return setRadius(const_cast<hkpShape*>(ts->getChildShape()), doneShapes);
        }
    case hkcdShapeType::BV:
        {
            hkpBvShape* bvShape = static_cast<hkpBvShape*>(shape);
            return setRadius( const_cast<hkpShape*>(bvShape->getChildShape()), doneShapes);
        }

    case hkcdShapeType::MOPP:
        {
            hkpMoppBvTreeShape* moppShape = static_cast<hkpMoppBvTreeShape*>(shape);
            return setRadius( const_cast<hkpShapeCollection*> (moppShape->getShapeCollection()), doneShapes); // storage mesh shape usally
        }
    case hkcdShapeType::TRIANGLE_COLLECTION: // MeshShape or SimpleMeshShape, have to find out..
    case hkcdShapeType::EXTENDED_MESH:
        {
            // find mesh shape class, and see if it is related to current shape
            const hkReflect::Type* klass = hkReflect::exactTypeOf(shape);

            if ( klass->equals<hkpMeshShape>() ||
                 klass->equals<hkpStorageMeshShape>() )
            {
                hkpMeshShape* meshShape = static_cast<hkpMeshShape*>( shape );
                meshShape->setRadius(m_options.m_radius);
            }
            else if ( klass->equals<hkpSimpleMeshShape>() )
            {
                hkpSimpleMeshShape* meshShape = static_cast<hkpSimpleMeshShape*>( shape );
                meshShape->setRadius(m_options.m_radius);
            }
            else if( klass->equals<hkpExtendedMeshShape>() ||
                klass->equals<hkpStorageExtendedMeshShape>() )
            {
                hkpExtendedMeshShape* extendedMeshShape = static_cast<hkpExtendedMeshShape*>( shape );
                extendedMeshShape->setRadius(m_options.m_radius);
            }
            return HK_NULL;
        }

    case hkcdShapeType::CONVEX_LIST:
    case hkcdShapeType::LIST:
    case hkcdShapeType::COLLECTION:
    case hkcdShapeType::TRI_SAMPLED_HEIGHT_FIELD_COLLECTION:
        {
            const hkpShapeContainer* container = shape->getContainer();
            hkpShapeBuffer buffer;
            HK_ASSERT(0xDBC09922, container, "Shape collection has a null container.");

            const bool isMutable = ((shape->getType() == hkcdShapeType::LIST) | (shape->getType() == hkcdShapeType::CONVEX_LIST));
            hkArray<hkpShape*> newShapes;
            newShapes.reserveExactly(container->getNumChildShapes());
            bool foundNewOnes = false;
            for (hkpShapeKey key = container->getFirstKey(); key != HK_INVALID_SHAPE_KEY; key = container->getNextKey( key ) )
            {
                const hkpShape* child = container->getChildShape(key, buffer );
                hkpShape* newShape = setRadius(const_cast<hkpShape*>(child), doneShapes);
                if (newShape)
                {
                    // ehh.. not in charge of the shapes in the collecton so can't change them
                    if (!isMutable)
                    {
                        HK_WARN_ALWAYS( 0xabba4f77, "Found a shape collection with children that required changing. Not processing.");
                    }
                    foundNewOnes = true;
                }
                newShapes.pushBack(newShape? newShape : const_cast<hkpShape*>(child) );
            }

            hkpShape* newS = HK_NULL;
            if (foundNewOnes && isMutable)
            {
                if ( shape->getType() == hkcdShapeType::LIST )
                    newS = new hkpListShape( newShapes.begin(), newShapes.getSize() );
                else if ( shape->getType() == hkcdShapeType::CONVEX_LIST )
                    newS = new hkpConvexListShape( (const hkpConvexShape**)newShapes.begin(), newShapes.getSize() );
            }
            return newS;
        }


    case hkcdShapeType::TRIANGLE:
    case hkcdShapeType::CYLINDER:
    case hkcdShapeType::BOX:
    case hkcdShapeType::CONVEX_VERTICES:
        {
            hkpConvexShape* cvxShape = static_cast<hkpConvexShape*>(shape);
            cvxShape->setRadius( m_options.m_radius );
            return HK_NULL;
        }

    //
    // Unhandled at this time
    //
    case hkcdShapeType::CONVEX_PIECE:
    case hkcdShapeType::SAMPLED_HEIGHT_FIELD:

    default:
        return HK_NULL;
    }
}

void hctSetRadiusFilter::process( hkRootLevelContainer& data )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    hkpPhysicsData* physicsPtr = data.findObject<hkpPhysicsData>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    if (physicsPtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No physics data found");
        return;
    }

    {
        hkArray<hkpShape*> doneShapes;
        hkArray<hkpPhysicsSystem*>& systems = const_cast<hkArray<hkpPhysicsSystem*>&>( physicsPtr->getPhysicsSystems() );
        for (int ps=0; ps < systems.getSize(); ++ps)
        {
            hkpPhysicsSystem* origSystem = systems[ps];
            // find all convex hulls that need to be shrunk
            const hkArray<hkpRigidBody*>& rbs = origSystem->getRigidBodies();
            for (int ri=0; ri < rbs.getSize(); ++ri)
            {
                hkpRigidBody* rb = rbs[ri];
                const bool isFixed = rb->isFixed();

                if (isFixed && (m_options.m_applyTo == hctSetRadiusOptions::APPLY_TO_DYNAMIC) )
                {
                    continue;
                }

                if (!isFixed && (m_options.m_applyTo == hctSetRadiusOptions::APPLY_TO_FIXED) )
                {
                    continue;
                }

                const hkpShape* s = rb->getCollidable()->getShape();
                hkpShape* newS = setRadius( const_cast<hkpShape*>(s), doneShapes );
                if (newS)
                {
                    rb->getCollidableRw()->setShape(newS);
                    // newS->removeReference(); shape doesn't get ref'd inside collidbale, let the rb have ours
                    s->removeReference();
                }

                hkVector4 extent;
                rb->updateCachedShapeInfo( s, extent);
            }
        }
    }
}

void hctSetRadiusFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctSetRadiusOptions* options = hctFilterUtils::getNativeOptions<hctSetRadiusOptions>(optVar))
    {
        m_options = *options;
        delete options;
    }
}

void hctSetRadiusFilter::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
