// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/FilterPhysics2012/OptimizeShapeHierarchy/hctOptimizeShapeHierarchyOptions.h>

class hctOptimizeShapeHierarchyFilter : public hctFilterInterface
{
    public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

    hctOptimizeShapeHierarchyFilter(const hctFilterManagerInterface* owner);

    /*virtual*/ ~hctOptimizeShapeHierarchyFilter();
    /*virtual*/ void process( class hkRootLevelContainer& data  );
    /*virtual*/ HWND showOptions(HWND owner);
    /*virtual*/ void hideOptions();
    /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
    /*virtual*/ int getOptionsSize() const;
    /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

    public:

        HWND m_optionsDialog;
        void setDataFromControls();
        void setControlsFromData();
        void enableControls();
        hctOptimizeShapeHierarchyOptions m_options;
        mutable hkArray<char> m_optionsBuf;

};



class hctOptimizeShapeHierarchyFilterDesc : public hctFilterDescriptor
{
    public:

    /*virtual*/ unsigned int getID() const { return 0x472e73da; }
    /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_PHYSICS_2012; }
    /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
    /*virtual*/ const char* getShortName() const { return "[Physics 2012] Optimize Shape Hierarchy"; }
    /*virtual*/ const char* getLongName() const { return "Optimize shape hierarchy by collapsing transform shapes where possible."; }
    /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,0,0); }
    /*virtual*/ hctFilterInterface* createFilter(const class hctFilterManagerInterface* owner) const { return new hctOptimizeShapeHierarchyFilter(owner); }

    /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_PHYSICS; }
};

extern hctOptimizeShapeHierarchyFilterDesc g_optimizeShapeHierarchyDesc;

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
