// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>


/// Options describing what to do to any meshes found.
class hctCreateWorldOptions
{
    public:

        HK_DECLARE_CLASS(hctCreateWorldOptions, New, Reflect, BypassCtor);

            /// Struct holding default values
        struct DefaultStruct;

            /// Default constructor
        hctCreateWorldOptions() { }

        enum CollisionFilterOptionsType
        {
            COLLISION_OPTIONS_INVALID,
            COLLISION_OPTIONS_NO_FILTER,
            COLLISION_OPTIONS_CONSTRAINT_FILTER,
            COLLISION_OPTIONS_GROUP_FILTER,
            COLLISION_OPTIONS_MAX_ID
        };

        enum SystemGroupingOptionsType
        {
            SYSTEM_GROUPING_OPTIONS_INVALID,
            SYSTEM_GROUPING_OPTIONS_SINGLE,
            SYSTEM_GROUPING_OPTIONS_CONSTRAINED_HIERARCHIES,
            SYSTEM_GROUPING_OPTIONS_MAX_ID
        };

    public:

        hkBool  m_createWorld;
        class hkpWorldCinfo m_worldCinfo;

        // extra info that is not explicitly stored in the cinfo but is used to fill it in:

        hkUint32 m_solverType;
        hkEnum<CollisionFilterOptionsType, hkUint8 > m_collisionFilterType;

        // group filter layers
        hkBool      m_autoGroupRBS;
        hkUint32        m_autoGroupRBLayer;
        hkUint32    m_groupFilterLayerTable[32];

        // system grouping
        hkEnum<SystemGroupingOptionsType, hkUint8 > m_systemGrouping;

};

HK_REFLECT_ENUM(/**/, hctCreateWorldOptions::CollisionFilterOptionsType);
HK_REFLECT_ENUM(/**/, hctCreateWorldOptions::SystemGroupingOptionsType);

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
