// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/FilterPhysics2012/CreateWorld/hctCreateWorldOptions.h>

class hctCreateWorldFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctCreateWorldFilter (const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctCreateWorldFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

    public:

        HWND m_optionsDialog;
        void updateOptions();

        hctCreateWorldOptions m_options;

        bool m_haveSetOptions;
        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;
};

class hctFilterCreateWorldDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0x2153ccbb; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_PHYSICS_2012; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "[Physics 2012] Create World"; }
        /*virtual*/ const char* getLongName() const { return "Create world information, such as gravity and collision filtering."; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,1,0); }
        /*virtual*/ hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctCreateWorldFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_PHYSICS; }
};

extern hctFilterCreateWorldDesc g_createWorldDesc;

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
