// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0

#pragma once
#include <Physics2012/Collide/Shape/Compound/Collection/Mesh/hkpNamedMeshMaterial.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/Channels/hkxTriangleSelectionChannel.h>

    /// Used when material names are concatenated.
#define MESH_MATERIAL_SEPARATOR ","

    /// Utility for extracting materials from triangle selections contained in meshes.
class hctNamedMeshMaterialsUtil
{
    public:
            /// Extract material information from the provided mesh.
            /// \param materialTableOut the table of named materials corresponding to triangle selections starting with the prefix.
            /// \param indicesOut a table of indices into the materialTable with an entry for every triangle.
            /// \param joinMaterials whether overlapping materials should be concatenated to make a new material type, or whether the first
            ///   material encountered should be used.
            /// \param overlap will be set to true if there were any overlapping materials.
        static void HK_CALL getNamedMaterials( const hkxMesh* mesh, hkArray<hkpNamedMeshMaterial>& materialTableOut, hkArray<hkUint16>& indicesOut, hkBool& overlap, const hkStringPtr& prefix, hkBool joinMaterials = false, hkBool useTriangleSelection = false );

    public:
            /// Does the user channel correspond to a material selection?
        static hkBool HK_CALL isUserChannelForMaterials( const hkxMesh::UserChannelInfo& userChannelInfo, const hkStringPtr& prefix );

            /// Does the prefix of the material name correspond to that of a named material?
        static hkBool HK_CALL isPrefixForMaterials( const hkStringPtr& name, const hkStringPtr& prefix );

            /// This utility uses a mapping table to map the triangle selection indices to material indices (needed when not all
            /// triangle selections are marked as materials using the MESH_MATERIAL_PREFIX).
        typedef hkArray<hkInt32> MappingTable;

            /// Obtain a table of material names from the mesh.
        static void HK_CALL getMaterialTable( const hkxMesh* mesh, hkArray<hkpNamedMeshMaterial>& materialTableOut, MappingTable& mappingOut, const hkStringPtr& prefix, hkBool useTriangleSelection );

            /// A table of triangles in their selections.
        typedef hkArray< hkArray<hkInt32> > TriangleSelectionTable;

            /// Return true if the section contains a triangle contained in a material selection.
        static hkBool HK_CALL getTriangleSelectionTableFromSection( const hkxMeshSection* section, TriangleSelectionTable& triSelectionChannels );

            /// For a triangle in a section whose triangle selection channels are as given, return the index into the material
            /// table.
            /// \param joinMaterials whether overlapping materials should be concatenated to make a new material type, or whether the first
            ///   material encountered should be used.
            /// \param overlap will be set to true if there were overlapping materials.
        static int HK_CALL getMaterialForTriangle( int triangleIndex, const TriangleSelectionTable& triSelectionChannels, const MappingTable& mapping, hkBool joinMaterials, hkArray<hkpNamedMeshMaterial>& materialTable, hkBool& overlap );
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
