// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Collide/Shape/Convex/hkpConvexShape.h>


/// Options describing what to do to any meshes found.
class hctCreateRigidBodiesOptions
{
    public:

        HK_DECLARE_CLASS(hctCreateRigidBodiesOptions, New, Reflect, BypassCtor);

            /// Default constructor
        hctCreateRigidBodiesOptions()
        :   m_bestFittingShapes(false)
        ,   m_mergeMeshDuplicates(false)
        ,   m_wrapWithMopp(true)
        ,   m_listShapesMoppThreshold(5)
        ,   m_enableMoppChunks(true)
        ,   m_spuOptimizedMopps(false)
        ,   m_spuOptimizedConvex(false)
        ,   m_weldOpenEdges(false)
        ,   m_weldAcrossAllMopps(false)
        ,   m_markEdgesBadWinding(false)
        ,   m_enableAutomaticShapeShrinking(true)
        ,   m_defaultConvexRadius(hkConvexShapeDefaultRadius)
        ,   m_maxVertexDisplacement(0.03f)
        ,   m_relShrinkRadius(0.05f)
        ,   m_exportDestructionInformation(true)
        ,   m_joinOverlappingMeshMaterials(false)
        {
        }

            /// If true, shapes will be oriented for best fitting.
        hkBool m_bestFittingShapes;

            /// If true, identical vertices and triangles will be merged when creating mesh shapes.
        hkBool m_mergeMeshDuplicates;

            /// If true, wraps compound shapes with MOPP code.
        hkBool m_wrapWithMopp;

            /// Compound shapes with a number of children equal to or greater than this value will be wrapped with a MOPP.
        int m_listShapesMoppThreshold;

            /// If true, build MOPPs with chunks for PlayStation(R)3 SPUs.
        hkBool m_enableMoppChunks;

            /// DEPRECATED: If true, MOPP code will be optimized for SPU usage.
        hkBool m_spuOptimizedMopps;

            /// DEPRECATED: If true, convex vertices shapes will be optimized for SPU usage.
        hkBool m_spuOptimizedConvex;

        enum LanscapeWelding
        {
            WELD_COUNTERCLOCKWISE,
            WELD_CLOCKWISE,
            WELD_TWO_SIDED,
            WELD_NONE
        };

            /// Triangle configuration, used for adding welding information to landscapes
        hkEnum<LanscapeWelding, hkUint8 > m_landscapeWelding;

            /// If true, non-shared (open) edges are ignored. Otherwise normals will be snapped to the face normal.
        hkBool m_weldOpenEdges;

            /// Consider all MOPPs when calculating the welding information.
        hkBool m_weldAcrossAllMopps;

            /// If this is true then the edges between triangles with inconsistent winding will be marked with 0x1f
        hkBool m_markEdgesBadWinding;

            /// If true, transforms will be collapsed into shapes whenever possible
        hkBool m_collapseShapeOffsetsIntoShapes;

            /// If true, automatic shape shrinking is applied to a shape. If false, the old style default convex radius will be used.
        hkBool m_enableAutomaticShapeShrinking;

            /// This is an override to the global hard-coded default convex radius value (hkConvexShapeDefaultRadius).
        hkReal m_defaultConvexRadius;

            /// <dd.todo.aaa>
        hkReal m_maxVertexDisplacement;

            /// <dd.todo.aaa>
        hkReal m_relShrinkRadius;

            /// The quantization error used to build the compressed mesh shape
        hkReal m_quantizationError;

            /// If true, the Create Rigid Bodies filter will output the rigid bodies in a special format that is understood by Havok Destruction.
        hkBool m_exportDestructionInformation;

            /// If true, the filter will concatenate overlapping materials to create a new material.
        hkBool m_joinOverlappingMeshMaterials;

            /// The name of a triangle selection must begin with this prefix for it to be considered a material.
            /// To reduce the likelihood of clashes, it is case sensitive.
        hkStringPtr m_materialPrefix;

        enum MeshShapeType
        {
            EXTENDED_MESH_SHAPE,
            COMPRESSED_MESH_SHAPE,
            SIMPLE_MESH_SHAPE,
            BV_COMPRESSED_MESH_SHAPE
        };

            /// The type of mesh shape to export to
        hkEnum<MeshShapeType, hkUint8 > m_meshShapeType;

        enum NamedMaterialSource
        {
            MATERIAL_NONE,
            MATERIAL_MESH_SECTIONS,
            MATERIAL_TRIANGLE_SELECTIONS
        };

        /// Select the source for exporting named mesh materials to be either the triangle selections from
        /// the Havok Mesh Channel Toolbox or the mesh section's material.
        hkEnum<NamedMaterialSource, hkUint8 > m_namedMaterialSource;

};

HK_REFLECT_ENUM(/**/, hctCreateRigidBodiesOptions::LanscapeWelding);
HK_REFLECT_ENUM(/**/, hctCreateRigidBodiesOptions::MeshShapeType);
HK_REFLECT_ENUM(/**/, hctCreateRigidBodiesOptions::NamedMaterialSource);

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
