// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterPhysics2012/hctFilterPhysics.h>
#include <ContentTools/Common/Filters/FilterPhysics2012/CreateRigidBodies/hctCreateRigidBodiesFilter.h>
#include <ContentTools/Common/Filters/Common/Utils/hctLocaleScope.h>

#include <Common/Base/Container/String/hkUtf8.h>

extern HINSTANCE hInstance;

inline void _enableConvexRadiusOptions( HWND dlg, hkBool32 enable )
{
    EnableWindow(GetDlgItem(dlg, IDC_STATIC_DEFAULT_CONVEX_RADIUS), enable);
    EnableWindow(GetDlgItem(dlg, IDC_EDIT_DEFAULT_CONVEX_RADIUS), enable);
}

inline void _enableAutomaticShrinkingOptions( HWND dlg, hkBool32 enable )
{
    EnableWindow(GetDlgItem(dlg, IDC_STATIC_MAX_VERTEX_DISPLACEMENT), enable);
    EnableWindow(GetDlgItem(dlg, IDC_STATIC_REL_SHRINK_RADIUS), enable);
    EnableWindow(GetDlgItem(dlg, IDC_EDIT_MAX_VERTEX_DISPLACEMENT), enable);
    EnableWindow(GetDlgItem(dlg, IDC_EDIT_REL_SHRINK_RADIUS), enable);
}

INT_PTR CALLBACK hkFilterCreateRigidBodiesDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctCreateRigidBodiesFilter* filter = reinterpret_cast<hctCreateRigidBodiesFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filter = (hctCreateRigidBodiesFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            hctCreateRigidBodiesOptions& filterOptions = filter->m_options;

            CheckDlgButton(hWnd, IDC_CB_BestFitShapes, filter->m_options.m_bestFittingShapes);
            CheckDlgButton(hWnd, IDC_CB_MergeDuplicates, filter->m_options.m_mergeMeshDuplicates);
            CheckDlgButton(hWnd, IDC_CB_WrapLists, filter->m_options.m_wrapWithMopp);
            CheckDlgButton(hWnd, IDC_CB_CollapseShapeTransformOffsets, filter->m_options.m_collapseShapeOffsetsIntoShapes);
            CheckDlgButton(hWnd, IDC_CB_EnableMoppChunks, filter->m_options.m_enableMoppChunks);
            CheckDlgButton(hWnd, IDC_CB_ExportDestructionInformation, filter->m_options.m_exportDestructionInformation);
            CheckDlgButton(hWnd, IDC_CB_WeldOpenEdges, filter->m_options.m_weldOpenEdges);
            CheckDlgButton(hWnd, IDC_CB_WeldAcrossAllMopps, filter->m_options.m_weldAcrossAllMopps);
            CheckDlgButton(hWnd, IDC_CB_MarkEdgesBadWinding, filter->m_options.m_markEdgesBadWinding);
            CheckDlgButton(hWnd, IDC_CB_JoinOverlappingMeshMaterials, filter->m_options.m_joinOverlappingMeshMaterials );

            {
                hctLocaleScope scope;

                hkStringOld s;
                s.printf("%d", filter->m_options.m_listShapesMoppThreshold);
                SetDlgItemText(hWnd, IDC_ED_WRAP_LISTS, s.cString());

                EnableWindow(GetDlgItem(hWnd, IDC_ED_WRAP_LISTS), filter->m_options.m_listShapesMoppThreshold);

                bool enableAutomaticShapeShrinking = filterOptions.m_enableAutomaticShapeShrinking;
                CheckDlgButton(hWnd, IDC_RADIO_CONVEX_RADIUS,      !enableAutomaticShapeShrinking);
                CheckDlgButton(hWnd, IDC_RADIO_AUTOMATIC_SHRINKING, enableAutomaticShapeShrinking);
                _enableConvexRadiusOptions      (hWnd, !enableAutomaticShapeShrinking);
                _enableAutomaticShrinkingOptions(hWnd,  enableAutomaticShapeShrinking);

                s.printf("%.3f", filter->m_options.m_defaultConvexRadius);
                SetDlgItemText(hWnd, IDC_EDIT_DEFAULT_CONVEX_RADIUS, s.cString());

                s.printf("%.3f", filter->m_options.m_maxVertexDisplacement);
                SetDlgItemText(hWnd, IDC_EDIT_MAX_VERTEX_DISPLACEMENT, s.cString());

                s.printf("%.1f", filter->m_options.m_relShrinkRadius * 100.0f);
                SetDlgItemText(hWnd, IDC_EDIT_REL_SHRINK_RADIUS, s.cString());

                s.printf("%.4f", filter->m_options.m_quantizationError);
                SetDlgItemText(hWnd, IDC_EDIT_QUANT_ERROR, s.cString());
            }

            bool enableQuantization = filter->m_options.m_meshShapeType == hctCreateRigidBodiesOptions::COMPRESSED_MESH_SHAPE;

            EnableWindow(GetDlgItem(hWnd, IDC_STATIC_QUANT_ERROR), enableQuantization);
            EnableWindow(GetDlgItem(hWnd, IDC_EDIT_QUANT_ERROR), enableQuantization);

            bool enableTriangleSelectionOptions = filter->m_options.m_namedMaterialSource == hctCreateRigidBodiesOptions::MATERIAL_TRIANGLE_SELECTIONS;

            EnableWindow(GetDlgItem(hWnd, IDC_CB_JoinOverlappingMeshMaterials ), enableTriangleSelectionOptions);
            EnableWindow(GetDlgItem(hWnd, IDC_EDIT_MATERIAL_PREFIX), enableTriangleSelectionOptions);
            EnableWindow(GetDlgItem(hWnd, IDC_STATIC_MATERIAL_PREFIX), enableTriangleSelectionOptions);

            SetDlgItemTextW(hWnd, IDC_EDIT_MATERIAL_PREFIX, hkUtf8::WideFromUtf8(filter->m_options.m_materialPrefix.cString()) );

            // Initialize welding combobox
            {
                // IMPORTANT - The order of addition must match the enum values
                HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_LandscapeWelding);
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Counterclockwise Oriented Triangles");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Clockwise Oriented Triangles");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Two-Sided Triangles");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "No Welding Info");

                SendMessage(hwndCombo, CB_SETCURSEL, (WPARAM)filter->m_options.m_landscapeWelding, 0);
            }

            // Initialize mesh shape type combobox
            {
                // IMPORTANT - The order of addition must match the enum values
                HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_MeshShapeType);
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Extended Mesh Shape");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "(Legacy) Compressed Mesh Shape");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Simple Mesh Shape");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "BV Compressed Mesh Shape");

                SendMessage(hwndCombo, CB_SETCURSEL, (WPARAM)filter->m_options.m_meshShapeType, 0);
            }

            // Initialize Named Mesh Material Source combobox
            {
                // IMPORTANT - The order of addition must match the enum values
                HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_NamedMaterialSource);
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "No Material Info");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Mesh Section Materials");
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) "Triangle Selection Sets");

                SendMessage(hwndCombo, CB_SETCURSEL, (WPARAM)filter->m_options.m_namedMaterialSource, 0);
            }

            // Initialize Tool Tips
            {
                {
                    CreateToolTip(IDC_EDIT_QUANT_ERROR, hWnd, hInstance, "");
                    CreateToolTip(IDC_CB_WeldAcrossAllMopps, hWnd, hInstance, "If enabled, welding information across all shapes will be calculated.");
                    CreateToolTip(IDC_COMBO_MeshShapeType, hWnd, hInstance, "By default, the filter will use the BV compressed mesh shape type (hkpBvCompressedMeshShape), which can hold convex shapes alongside the landscape information. So, for compound rigid bodies, the filter will add any convex shapes belonging to the rigid body to the mesh shape, while using a compact representation. For more information about different mesh shapes, please check the Havok Physics SDK documentation.");

                    CreateToolTip(IDC_COMBO_NamedMaterialSource, hWnd, hInstance, "If Mesh Section Materials is selected, the filter will use materials from mesh sections as mesh materials. If Triangle Selection Sets is selected, the filter will use triangle selections from Havok Mesh Channel Toolbox as mesh materials");
                    CreateToolTip(IDC_CB_WeldOpenEdges, hWnd, hInstance, "If enabled, unconnected Mesh edge normals will be welded so that they parallel the triangle normal.");
                    CreateToolTip(IDC_CB_MarkEdgesBadWinding, hWnd, hInstance, "If enabled, the edges between triangles with inconsistent winding will be marked and can be viewed as a red line in the Visual Debugger.");
                    const char convexRadiusToolTip[] = "This value allows for globally setting the default value for the Extra Radius available in some physics shapes like Box or Sphere. This is only used if you have not set the convex radius in the physics shape in the modeler. This normally increases the size of the shape (by the radius) and is normally used in combination with the shape shrinker, which shrinks it back to the normal size. This is used to improve collision detection performance. However it is advisable to use a different system to optimize your shapes and not use the shape shrinker filter, but use the Max Vertex Displacement and Relative Shrink Radius value pair instead.";
                    CreateToolTip(IDC_STATIC_DEFAULT_CONVEX_RADIUS, hWnd, hInstance, convexRadiusToolTip);
                    CreateToolTip(IDC_RADIO_CONVEX_RADIUS, hWnd, hInstance, convexRadiusToolTip);
                    CreateToolTip(IDC_EDIT_DEFAULT_CONVEX_RADIUS, hWnd, hInstance, convexRadiusToolTip);
                    const char autoShrinkToolTip[] = "If enabled, the shape will be shrunken at construction time by the size of the shape multiplied by Relative Shrink Radius. However if the shape has very sharp edges, shrinking the shape only by a small amount could result in vertices being moved by a big distance. This parameter limits the shrink value so that no vertex is moved more than this value. The amount the shape is shrunk is used as the convex radius to grow the shape to its original size.";
                    CreateToolTip(IDC_STATIC_MAX_VERTEX_DISPLACEMENT, hWnd, hInstance, autoShrinkToolTip);
                    CreateToolTip(IDC_RADIO_AUTOMATIC_SHRINKING, hWnd, hInstance, autoShrinkToolTip);
                    CreateToolTip(IDC_EDIT_MAX_VERTEX_DISPLACEMENT, hWnd, hInstance, autoShrinkToolTip);
                    const char relativeShrinkRadiusToolTip[] = "This defines the relative size of the shape which is used to optimize collision detection. Basically the vertices of the shape are shrunken by this relative value and then the entire shape is expanded back again by setting the convex radius. This value is closely tied to Max. Vertex Displacement. Once an overriding Extra Radius is specified in a particular Physics Shape then the relative shrinking is disabled for this Rigid Body and the absolute value from the shape will be used instead.";
                    CreateToolTip(IDC_EDIT_REL_SHRINK_RADIUS, hWnd, hInstance, relativeShrinkRadiusToolTip);
                    CreateToolTip(IDC_STATIC_REL_SHRINK_RADIUS, hWnd, hInstance, relativeShrinkRadiusToolTip);
                    CreateToolTip(IDC_CB_ExportDestructionInformation, hWnd, hInstance, "If enabled, the filter will output the rigid bodies in a format which is understood by Havok Destruction. This is necessary if using the Destruction Filter." );
                }

                CreateToolTip(IDC_CB_BestFitShapes, hWnd, hInstance, "If enabled, the filter will look for a best-fitting orientation for box, capsule and cylinder shapes rather than aligning those shapes to the transform of the scene node. Enable this option if you want the shapes to be based solely on the vertices of the mesh, regardless of the axes of the node transform. Normally this option is not required.");
                CreateToolTip(IDC_CB_MergeDuplicates, hWnd, hInstance, "If enabled, the filter will look for duplicated vertices (and triangles) in meshes and ignore them when creating Havok shapes. This reduces the memory overhead and improves run-time performance of collision detection.");
                CreateToolTip(IDC_CB_WrapLists, hWnd, hInstance, "If enabled, will tell the filter to use Havok MOPP technology with compound shapes with more than the specified number of children. In many cases, this will speed up simulation.");
                CreateToolTip(IDC_ED_WRAP_LISTS, hWnd, hInstance, "Specify threshold at which compound shapes will use Havok MOPP technology.");
                CreateToolTip(IDC_CB_CollapseShapeTransformOffsets, hWnd, hInstance, "If enabled, the filter will attempt to collapse intermediate transforms into leaf shapes (for the case of convex shapes and mesh shapes). If the option is disabled, the filter will keep shapes in their local space (the space of the node representing the shape). This facilitates instancing (sharing) of shapes. However, if the shape and its rigid body are in different locations in space, extra transform shapes are required to represent that offset. Enabling this option will remove those extra transform shapes by baking them into the convex / mesh shape. The option has no effect on bounding shapes (box, sphere, capsule and cylinder).");
                CreateToolTip(IDC_CB_EnableMoppChunks, hWnd, hInstance, "This tells the MOPP compiler to organize the MOPP code into smaller chunks so it can be processed on the PLAYSTATION(R)3 SPU.");
                CreateToolTip(IDC_COMBO_LandscapeWelding, hWnd, hInstance, "This will add extra information to Mesh Shapes regarding welding, improving collision detection and resolution across triangle boundaries. In order to calculate this information, the filter needs to know what side of the triangles is considered to be UP. It will use the ordering of the triangle vertices in order to define this UP side. By default, most modelers use counter-clockwise orientation (where vertices are ordered in counter-clockwise order when viewed from the UP side).");
                CreateToolTip(IDC_CB_JoinOverlappingMeshMaterials, hWnd, hInstance, "If enabled, the names of overlapping mesh materials will be concatenated to create a new mesh material.");
                CreateToolTip(IDC_EDIT_MATERIAL_PREFIX, hWnd, hInstance, "The name of a triangle selection must begin with this prefix for it to be considered a material.");
            }

            return TRUE; // did handle it
        }
        case WM_COMMAND: // UI Changes
        {
            bool moppEnabled = IsDlgButtonChecked(hWnd, IDC_CB_WrapLists) != 0;

            EnableWindow(GetDlgItem(hWnd, IDC_CB_EnableMoppChunks), moppEnabled);
            EnableWindow(GetDlgItem(hWnd, IDC_ED_WRAP_LISTS), moppEnabled);

            hctCreateRigidBodiesOptions& filterOptions = filter->m_options;

            switch (LOWORD(wParam))
            {
                case IDC_COMBO_MeshShapeType:
                {
                    HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_MeshShapeType);
                    LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, (WPARAM)filter->m_options.m_meshShapeType, 0);

                    hkBool isCompressedMesh = (hctCreateRigidBodiesOptions::MeshShapeType (sel) == hctCreateRigidBodiesOptions::COMPRESSED_MESH_SHAPE );
                    EnableWindow(GetDlgItem(hWnd, IDC_STATIC_QUANT_ERROR), isCompressedMesh);
                    EnableWindow(GetDlgItem(hWnd, IDC_EDIT_QUANT_ERROR), isCompressedMesh);

                    break;
                }
                case IDC_COMBO_LandscapeWelding:
                {
                    HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_LandscapeWelding);
                    LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, (WPARAM)filter->m_options.m_landscapeWelding , 0);

                    hkBool doWelding = !( hctCreateRigidBodiesOptions::LanscapeWelding (sel) == hctCreateRigidBodiesOptions::WELD_NONE );
                    EnableWindow(GetDlgItem(hWnd, IDC_CB_WeldOpenEdges), doWelding);
                    EnableWindow(GetDlgItem(hWnd, IDC_CB_WeldAcrossAllMopps), doWelding);
                    EnableWindow(GetDlgItem(hWnd, IDC_CB_MarkEdgesBadWinding), doWelding);

                    break;
                }
                case IDC_COMBO_NamedMaterialSource:
                    {
                        HWND hwndCombo = GetDlgItem(hWnd, IDC_COMBO_NamedMaterialSource);
                        LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, (WPARAM)filter->m_options.m_namedMaterialSource , 0);

                        hkBool isTriangleSelection = (hctCreateRigidBodiesOptions::NamedMaterialSource (sel) == hctCreateRigidBodiesOptions::MATERIAL_TRIANGLE_SELECTIONS );
                        EnableWindow(GetDlgItem(hWnd, IDC_STATIC_MATERIAL_PREFIX), isTriangleSelection);
                        EnableWindow(GetDlgItem(hWnd, IDC_EDIT_MATERIAL_PREFIX), isTriangleSelection);
                        EnableWindow(GetDlgItem(hWnd, IDC_CB_JoinOverlappingMeshMaterials), isTriangleSelection);

                        break;
                    }
                case IDC_RADIO_CONVEX_RADIUS:
                {
                    _enableConvexRadiusOptions      (hWnd, true);
                    _enableAutomaticShrinkingOptions(hWnd, false);
                    filterOptions.m_enableAutomaticShapeShrinking = false;
                    break;
                }
                case IDC_RADIO_AUTOMATIC_SHRINKING:
                {
                    _enableConvexRadiusOptions      (hWnd, false);
                    _enableAutomaticShrinkingOptions(hWnd, true);
                    filterOptions.m_enableAutomaticShapeShrinking = true;
                    break;
                }
            }

            break;
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}

HWND hctCreateRigidBodiesFilter::showOptions (HWND owner)
{
    if (m_optionsDialog)
    {
        hideOptions();
    }

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_CREATE_RIGID_BODIES_DIALOG),
        owner, hkFilterCreateRigidBodiesDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctCreateRigidBodiesFilter::updateOptions()
{
    if (m_optionsDialog)
    {
        // Query current locale, then temporarily switch it to "C"
        hctLocaleScope scope;

        m_options.m_joinOverlappingMeshMaterials = IsDlgButtonChecked(m_optionsDialog, IDC_CB_JoinOverlappingMeshMaterials) != FALSE;
        m_options.m_bestFittingShapes = IsDlgButtonChecked(m_optionsDialog, IDC_CB_BestFitShapes) != FALSE;
        m_options.m_mergeMeshDuplicates = IsDlgButtonChecked(m_optionsDialog, IDC_CB_MergeDuplicates) != FALSE;
        m_options.m_collapseShapeOffsetsIntoShapes = IsDlgButtonChecked(m_optionsDialog, IDC_CB_CollapseShapeTransformOffsets) != FALSE;
        m_options.m_exportDestructionInformation = IsDlgButtonChecked(m_optionsDialog, IDC_CB_ExportDestructionInformation) != FALSE;
        m_options.m_weldOpenEdges = IsDlgButtonChecked(m_optionsDialog, IDC_CB_WeldOpenEdges) != FALSE;
        m_options.m_weldAcrossAllMopps = IsDlgButtonChecked(m_optionsDialog, IDC_CB_WeldAcrossAllMopps) != FALSE;
        m_options.m_markEdgesBadWinding = IsDlgButtonChecked(m_optionsDialog, IDC_CB_MarkEdgesBadWinding) != FALSE;
        m_options.m_enableAutomaticShapeShrinking = IsDlgButtonChecked(m_optionsDialog, IDC_RADIO_AUTOMATIC_SHRINKING) != FALSE;


        if (IsDlgButtonChecked(m_optionsDialog, IDC_CB_WrapLists))
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_ED_WRAP_LISTS), text, 256);
            m_options.m_listShapesMoppThreshold = atoi(text);
        }
        m_options.m_wrapWithMopp = IsDlgButtonChecked(m_optionsDialog, IDC_CB_WrapLists) != 0;

        m_options.m_enableMoppChunks = IsDlgButtonChecked(m_optionsDialog, IDC_CB_EnableMoppChunks) != 0;

        // Welding enum
        {
            HWND hwndCombo = GetDlgItem(m_optionsDialog, IDC_COMBO_LandscapeWelding);
            LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, 0, 0);
            m_options.m_landscapeWelding = hctCreateRigidBodiesOptions::LanscapeWelding (sel);
        }

        // Mesh shape enum
        {
            HWND hwndCombo = GetDlgItem(m_optionsDialog, IDC_COMBO_MeshShapeType);
            LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, 0, 0);
            m_options.m_meshShapeType = hctCreateRigidBodiesOptions::MeshShapeType (sel);
        }

        // Named mesh materials enum
        {
            HWND hwndCombo = GetDlgItem(m_optionsDialog, IDC_COMBO_NamedMaterialSource);
            LRESULT sel = SendMessage(hwndCombo, CB_GETCURSEL, 0, 0);
            m_options.m_namedMaterialSource = hctCreateRigidBodiesOptions::NamedMaterialSource (sel);
        }

        // Default Convex Radius
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_EDIT_DEFAULT_CONVEX_RADIUS), text, 256);
            m_options.m_defaultConvexRadius = (hkReal)atof(text);
            if ( m_options.m_defaultConvexRadius < 0.0f )
            {
                m_options.m_defaultConvexRadius = 0.0f;
            }
        }

        // Max Vertex Displacement
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_EDIT_MAX_VERTEX_DISPLACEMENT), text, 256);
            m_options.m_maxVertexDisplacement = (hkReal)atof(text);
            if ( m_options.m_maxVertexDisplacement < 0.0f )
            {
                m_options.m_maxVertexDisplacement = 0.0f;
            }
        }

        // Rel Shrink Radius
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_EDIT_REL_SHRINK_RADIUS), text, 256);
            m_options.m_relShrinkRadius = (hkReal)atof(text) * 0.01f;
            if ( m_options.m_relShrinkRadius < 0.0f )
            {
                m_options.m_relShrinkRadius = 0.0f;
            }
            else if ( m_options.m_relShrinkRadius > 1.0f )
            {
                m_options.m_relShrinkRadius = 1.0f;
            }
        }

        // Quantization Error
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_EDIT_QUANT_ERROR), text, 256);
            m_options.m_quantizationError = (hkReal)atof(text);
            if ( m_options.m_quantizationError < 0.0001f )
            {
                m_options.m_quantizationError = 0.0001f;
            }
            else if ( m_options.m_quantizationError > 0.9f )
            {
                m_options.m_quantizationError = 0.9f;
            }
        }

        // Material Prefix
        {
            TCHAR text[256];
            GetWindowText(GetDlgItem(m_optionsDialog, IDC_EDIT_MATERIAL_PREFIX ), text, 256);
            m_options.m_materialPrefix = text;
        }
    }
}

void hctCreateRigidBodiesFilter::hideOptions()
{
    updateOptions();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
