// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/FilterPhysics2012/CreateRigidBodies/hctCreateRigidBodiesOptions.h>

#include <Physics2012/Collide/Util/Welding/hkpMeshWeldingUtility.h>
#include <Physics2012/Collide/Shape/Compound/Collection/ExtendedMeshShape/hkpExtendedMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/StorageExtendedMesh/hkpStorageExtendedMeshShape.h>

class hkResourceContainer;
class hkpShapeInfo;
template <typename Value, typename Allocator> class hkStringMap;
class hkLocalFrameGroup;
class hkpBinaryAction;
struct hkGeometry;
class hkxTriangleSelectionChannel;
class hkpListShape;
class hkpStorageExtendedMeshShape;
class hkpCompressedMeshShape;
class hkpBvCompressedMeshShape;

#define DEFAULT_MATERIAL_PREFIX "hkm_"

class hctCreateRigidBodiesFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctCreateRigidBodiesFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctCreateRigidBodiesFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;
        /*virtual*/ void hideOptions();

        struct ShapeInfo
        {
            hkTransform m_decomposedWorldT; // space that the shape was created in once the scale etc was baked out
            class hkpShape* m_shape; // the shape itself
            bool m_isConvex; // whether the object is convex
            hkTransform m_extraShapeTransform; // information about the extra transformation required to create the shape
            const hkxNode* m_node; // node used to create the shape - used to get its name, mostly
        };

    public:

        hctCreateRigidBodiesOptions m_options;

        HWND m_optionsDialog;
        void updateOptions();

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;

        hkArray< hkpMeshWeldingUtility::ShapeInfo > m_moppShapes;

    private:

        struct UnresolvedBinaryAction
        {
            hkpBinaryAction* m_action;
            const char* m_bodyNameForEntityB;
        };


            // note: collectHkdShapeShapes: if set, than the breakable body does not have any shapes itself, so we simply steal the shapes from the children
        void makeShapes(const hkxNode* n, const hkxScene* theScene, const hkMatrix4& currentWorldTransform, const hkTransform& rbTransform, bool collectHkdShapeShapes, bool isDynamic, hkArray<ShapeInfo>& shapes);
        void makeProperties(const hkxNode* node, const hkxScene* theScene, hkpRigidBody* rb);

        hkpShape* gatherShapes(const hkxNode* node, hkArray<hctCreateRigidBodiesFilter::ShapeInfo>& shapes, const hkTransform& rbTransform);

            // Note: hkdShapesCollected is set to true, if the physics shapes is a list shape which contains children, which have an hkdShape
        class hkpRigidBody* makeRigidBody(const hkxNode* n, const hkxScene* theScene, const hkxAttributeGroup& group, const hkMatrix4& currentWorldTransform, hkArray<ShapeInfo>& shapeInfosOut, bool& hkdShapesCollected, hkStringMap<hkLocalFrameGroup*, hkContainerHeapAllocator>& groupsCreated);

        class hkpShapeInfo* makeShape(const hkxNode* n, const hkxScene* theScene, const hkMatrix4& currentWorldTransform, const hkTransform& lastRbTransform);
        void fillSystem(const hkxNode* node, const hkxScene* theScene, const hkMatrix4& currentWorldTransform, const hkTransform& lastRbTransform, hkpPhysicsSystem* system, hkResourceContainer* resourceContainer, hkStringMap<hkLocalFrameGroup*, hkContainerHeapAllocator>& groupsCreated, hkArray<UnresolvedBinaryAction>& unresolvedBinaryAction);

            // See EXP-366
        bool computeOBB(const hkxMesh* mesh, const hkMatrix4& vertexTransform, hkVector4& halfExtentsOut, hkTransform& obbTransformOut);
        bool computeAABB(const hkxMesh* mesh, const hkMatrix4& vertexTransform, hkVector4& halfExtentsOut, hkTransform& obbTransformOut);

            // Get the geometry and materials from the node's mesh. Also merges duplicate vertices and triangles if option is set.
        void getGeometryAndMaterials( const hkxNode* node, const hkMatrix4& vertexTransform, hkArray<hkpNamedMeshMaterial>& materialsOut, hkArray<hkUint16>& indicesOut, hkGeometry& geometryOut, hkBool mergeDuplicates );

            // Setup of MOPP code and welding information
        hkpShape* setupMoppAndWelding (hkpShapeCollection* shapeCollection, const hkxNode* node, const hkTransform& rbTransform );

            // Shape creation
        bool createBoxShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
        bool createSphereShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
        bool createCapsuleShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
        bool createCylinderShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
        bool createHullShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
        bool createMeshShape (const hkxNode* n, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, ShapeInfo& infoOut);

        hkBool shouldBuildBvCompressedMesh( const hkxNode* node, const hkArray<hctCreateRigidBodiesFilter::ShapeInfo>& shapes );
        hkBool shouldBuildCompressedMesh( const hkxNode* node, const hkArray<hctCreateRigidBodiesFilter::ShapeInfo>& shapes );
        hkpListShape* buildListShapeFromConvexShapes( hkArray<hkpConvexShape*>& convexChildShapes );
        hkpStorageExtendedMeshShape* buildExtendedMeshFromCompound( hkArray<hkpConvexShape*>& convexChildShapes, hkArray<ShapeInfo*>& meshChildShapes, const hkTransform& rbTransform);
        hkpCompressedMeshShape* buildCompressedMesh( hkArray<hkpConvexShape*>& convexChildShapes, hkArray<ShapeInfo*>& meshChildShapes, const hkTransform& rbTransform);
        hkpBvCompressedMeshShape* buildBvCompressedMesh( hkArray<hkpConvexShape*>& convexChildShapes, hkArray<ShapeInfo*>& meshChildShapes, const hkTransform& rbTransform, const hkArray<hkpNamedMeshMaterial> & convexNamedMaterials);

        // EXP-580 - Keep track of creates shapes from hkxMeshes so we can reuse them
        struct InstancedShapeData
        {
            hkxMesh* m_originalMesh;
            float m_extraRadius;
            int m_shapeType;
            hkMatrix4 m_vertexTransform;
            ShapeInfo m_havokShape;
        };

        hkArray<InstancedShapeData> m_instancedShapesData;
        void registerCreatedShape (const hkxNode* node, const hkxAttributeGroup* shapeAttribs, const hkMatrix4& vertexTransform, const ShapeInfo& info);
        bool lookForInstancedShape (const hkxNode* node, const hkxAttributeGroup* shapeAttribs,  const hkMatrix4& vertexTransform, ShapeInfo& infoOut);
};


class hctCreateRigidBodiesFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0xb3e7846f; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_PHYSICS_2012; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "[Physics 2012] Create Rigid Bodies"; }
        /*virtual*/ const char* getLongName() const { return "Create rigid bodies from the attributes stored in the nodes."; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,9,2); }
        /*virtual*/ hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctCreateRigidBodiesFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_PHYSICS; }
};

extern hctCreateRigidBodiesFilterDesc g_createRigidBodiesDesc;

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
