// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Convex/hkpConvexShape.h>
#include <Physics/Constraint/Atom/hkpConstraintAtom.h>


//
/// Options describing what to do to any constraints found.

class hctCreateConstraintsOptions
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT, hctCreateConstraintsOptions);
        HK_DECLARE_REFLECTION();

    public:

        //
        /// Default constructor

        hctCreateConstraintsOptions()
        :   m_enableAutoInertiaStabilization(true)
        ,   m_stabilizationAmount(1.0f)
        ,   m_constraintsSolvingMethod(hkpConstraintAtom::METHOD_STABILIZED)
        {
        }

    public:

            /// If set to true, the constrained rigid bodies will have their inverse inertias modified so that attached
            /// constraints become more stable. The amount of modification is controlled by stabilizationAmount
        hkBool m_enableAutoInertiaStabilization;

            /// Amount of inertia stabilization applied; ranges between 0 (no stabilization, inertia tensors are left unchanged)
            /// to 1 (full stabilization, inertia tensors are modified to achieve a stable constraint simulation).
        hkReal m_stabilizationAmount;

            /// Constraints solving method
        hkEnum<hkpConstraintAtom::SolvingMethod, hkUint8> m_constraintsSolvingMethod;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
