// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/FilterPhysics2012/CreateConstraints/hctCreateConstraintsOptions.h>

class hctCreateConstraintsFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctCreateConstraintsFilter (const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctCreateConstraintsFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;
        /*virtual*/ void hideOptions();

    public:

        hctCreateConstraintsOptions m_options;

        HWND m_optionsDialog;
        void updateOptions();

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;

    protected:

        class hkpConstraintInstance* makeConstraint(class hkpPhysicsData* physicsPtr, const hkxScene* theScene, class hkxNode* n, int groupIndex, const hkMatrix4& currentWorldTransform);
        void convertConstraints(class hkpPhysicsData* physicsPtr, const hkxScene* theScene, hkxNode* node, const hkMatrix4& currentWorldTransform, hkArray<class hkpConstraintInstance*>& constraints );

        struct ConstraintSpaceData
        {
            hkRotation m_transformedBasis;
            hkTransform m_parentSpace;
            hkTransform m_childSpace;
            hkTransform m_childRBTransform;
            hkTransform m_parentRBTransform;
        };

        class hkpConstraintData* createBallAndSocketConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createHingeConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createRagdollConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createPrismaticConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createStiffSpringConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createWheelConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);
        class hkpConstraintData* createFixedConstraint (const ConstraintSpaceData& commonData, const hkxAttributeGroup& attribs);

        // (Possibly) constructs the motor described in the constraint attributes. Returns HK_NULL if none.
        class hkpConstraintMotor* createMotor (const hkxAttributeGroup& attribs);
};

class hctCreateConstraintsFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0xc4e7956f; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_PHYSICS_2012; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "[Physics 2012] Create Constraints"; }
        /*virtual*/ const char* getLongName() const { return "Create constraints between bodies from the attributes stored in the nodes. Must be after the create body filter."; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,0,0); }
        /*virtual*/ hctFilterInterface* createFilter(const class hctFilterManagerInterface* owner) const { return new hctCreateConstraintsFilter(owner); }

        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_PHYSICS; }
};

extern hctCreateConstraintsFilterDesc g_createConstraintsDesc;

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
