// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : PHYSICS_2012
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// Describes the Create Ragdoll Instance options.
class hctCreateConstraintChainsOptions
{
public:

    HK_DECLARE_CLASS(hctCreateConstraintChainsOptions, New, Reflect);

        // Struct holding default values
    struct DefaultStruct;

        // Default constructor
    hctCreateConstraintChainsOptions()
    {
        m_physicsSystemName = HK_NULL;
        m_rbStartNames = HK_NULL;
        m_rbEndNames = HK_NULL;
        m_createLimitConstraints = false;
        m_cloneMotors = false;
    }

        //
        // Members
        //
public:

        // Name of the physics system
    hkStringPtr m_physicsSystemName;

        // Name of the rbs starts of the chain, separated by ";"
    hkStringPtr m_rbStartNames;

        // Name of the rbs ends of the chain, separated by ";"
    hkStringPtr m_rbEndNames;

        // Limit constraints use information from the existing powered/non-powered ragdoll/hinge constraints only.
        // No limit constraints are created for any other types of constraints.
        // Default : false
    hkBool m_createLimitConstraints;

        // Should the chains clone motors or reuse the ones from the original constraints.
        // Default : false
    hkBool m_cloneMotors;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
