// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImplDll.h>

#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImpl.h>
#include <Shlwapi.h>

// This dll registers patches so it needs a patch registration node
#include <Common/Base/Reflect/Version/hkPatchesRegNode.h>

hctFilterManagerImplDll::hctFilterManagerImplDll (HMODULE dllModule) : hctFilterManagerDll (dllModule)
{

}

hctFilterManagerInterface* hctFilterManagerImplDll::createFilterManager (const hkMemoryInitUtil::SyncInfo* memSyncInfo, hkBool interactive)
{
    char havokPath[MAX_PATH];
    GetModuleFileName( m_dllModule, havokPath, MAX_PATH );
    PathRemoveFileSpec( havokPath );

    return new hctFilterManagerImpl(havokPath, memSyncInfo, interactive);
}


void hctFilterManagerImplDll::deleteFilterManager (hctFilterManagerInterface* f)
{
    delete static_cast<hctFilterManagerImpl*> (f);
}


// Function exported by the DLL
__declspec( dllexport ) hctFilterManagerDll* getFilterManagerDll (HMODULE dllModule)
{
    static hctFilterManagerImplDll g_filterManagerImplDll (dllModule);
    return &g_filterManagerImplDll;
}

extern void registerCommonPatches(hkReflect::Version::PatchHandler& man);
hkReflect::Detail::PatchesRegNode registerCommonPatches_reg(registerCommonPatches);

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
