// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <ContentTools/Common/Filters/Common/Options/hctFilterConfigurationSet.h>

/// This is the actual implementation of the filter manager
class hctFilterManagerImpl : public hkReferencedObject, public hctFilterManagerInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctFilterManagerImpl(const char* havokPath, const hkMemoryInitUtil::SyncInfo* memSyncInfo, hkBool interactive);
        ~hctFilterManagerImpl();

        /// hkFilterManager interface - check hctFilterManagerInterface.h for details on these methods

        /*virtual*/ unsigned int getFilterManagerVersion() const;

        /*virtual*/ int getConfigurationSet(void* optionData) const;
        /*virtual*/ void setConfigurationSet(const void* optionData, int optionDataSize);

        /*virtual*/ void openFilterManager (HWND owner, const hkRootLevelContainer& data, hkBool& shouldSaveConfigOut);
        /*virtual*/ void processBatch (HWND owner, const hkRootLevelContainer& data, hkBool& configModifiedOut, int configToRun = -1, bool allowModlessFilters = false);
        /*virtual*/ hkRootLevelContainer* processBatchReturnData( HWND owner, const class hkRootLevelContainer& data, int configToRun, bool allowModlessFilters, hkResource*& sceneCopyStorage );

        /*virtual*/ void getFileDependencies(HWND owner, const class hkRootLevelContainer& data, hkArray<hkStringPtr>& fileDependencies, int configIndex );

        /*virtual*/ const class hkRootLevelContainer* getOriginalContents () const;
        /*virtual*/ class hctSceneExportError* getErrorHandler();

        /*virtual*/ bool getInputContentsToCurrentFilter(hkRootLevelContainer** outputData, hkResource*& sceneCopyStorage ) const;

        /*virtual*/ void registerThreadCallback (const class hctFilterThreadCallback* cb);
        /*virtual*/ void setThreadData(hkMemoryRouter* memRouter) const;

        /*virtual*/ bool selectObjectFromTree( HWND owner, const char* title, class hctTreeViewManager* tvManager, hkVariant& selected ) const;
        /*virtual*/ int selectItemFromList( HWND owner, const char* title, const hkArray<const char*>& items ) const;
        /*virtual*/ void showItems( HWND owner, const char* title, const hkArray<const char*>& items ) const;

        /*virtual*/ HWND getMainWindowHandle () const;
        /*virtual*/ HWND getOwnerWindowHandle () const;
        /*virtual*/ ProcessMode getProcessMode() const;

        /*virtual*/ int getResult() const;

        virtual hkReferencedObject* getStoredObject( const char* name ) const;
        virtual void storeObject( const char* name, hkReferencedObject* object );
        virtual void removeStoredObject( const char* name );
        virtual void removeAllStoredObjects();

        virtual const class hctFilterDllManager* getDllManager() const HK_OVERRIDE;
        virtual const char* getHavokPath() const HK_OVERRIDE;

    public:

        // Processing
        hkRootLevelContainer* processNoWait( HWND owner, int configIndex, hkResource** sceneCopyStorage );
        void showStatus( const char* status ) const;
        void showHelp( HWND owner ) const;

        // Get/set the current product
        hctFilterDescriptor::HavokComponentMask getAvailableHavokComponents() const;
        void setAvailableHavokComponents( hctFilterDescriptor::HavokComponentMask product ) const;
        bool checkProductSupport (hctFilterDescriptor::HavokComponentMask requiredComponents) const;
        static const char* getProductNameBasedOnComponents (hctFilterDescriptor::HavokComponentMask components);

        // Set environment variables based on a specific configuration
        void setEnvironmentVariables( hkRootLevelContainer* rootLevelcontainer, const hctFilterConfigurationSet::Configuration& config ) const;


        HWND m_ownerWnd;
        const hkStringOld                   m_havokPath;    // path to the HCT folder
        class hctFilterError*       m_errorHandler;
        class hctFilterDllManagerImpl*      m_dllManager;
        class hctFilterConfigurationSet*    m_configurationSet;
        hkArray<const hctFilterThreadCallback*> m_threadCallbacks;
        mutable hkStringOld             m_status;
        mutable ProcessMode             m_processMode;
        int m_result;

        // Component dialogs of the filter manager
        HWND m_mainWnd;
        HWND m_filtersWnd;
        HWND m_configurationWnd;
        HWND m_optionsWnd;
        HWND m_processingWnd;

        // Info on the currently selected filter
        struct FilterDialogInformation
        {
            int m_filterIndex;
            int m_stageIndex;
            hctFilterInterface* m_filter;
            HWND m_dlg;

            FilterDialogInformation()
            {
                hkString::memSet( this, 0, sizeof(*this) );
            }
        } m_currentFilterDialog;

        // Info on the currently filter being processed
        struct ProcessingFilterInformation
        {
            int m_configIndex;
            int m_stageIndex;

            ProcessingFilterInformation() : m_configIndex(-1), m_stageIndex(-1) {}
        } m_currentFilterBeingProcessed;

        // Returns the icon id associated with a particular category
        static int categoryToIconID (hctFilterDescriptor::FilterCategory category);

        // Preset configuration set file paths
        hkArray <hkStringOld> m_HKOFilePaths;

        // Preset Configuration menu item in the file menu
        HMENU m_PresetConfigMenu;

    private:

        const hkRootLevelContainer*     m_originalContents;

        hkStringMap< hkReferencedObject* > m_storage;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
