// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <Common/Base/KeyCode.h>

#define HK_EXCLUDE_FEATURE_PhysicsRuntime
#define HK_EXCLUDE_FEATURE_Physics2012Runtime
#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_MemoryTracker
#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#define HK_EXCLUDE_FEATURE_RegisterVersionPatches
#define HK_EXCLUDE_FEATURE_hkFormatYamlFile
#include <Common/Base/Config/hkProductFeatures.cxx>

HINSTANCE hInstance;
static BOOL CommonControlsInitialized = FALSE;
static HMODULE RichEditCtrlLib = NULL;

BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    switch ( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
        {
            hInstance = hinstDLL;               // Hang on to this DLL's instance handle.

            if (!CommonControlsInitialized) {

                CommonControlsInitialized = TRUE;
                RichEditCtrlLib = LoadLibrary("Riched20.dll"); // Load the richedit dll (it registers that class in its dll init)
                InitCommonControls();           // Initialize Win32 controls
            }
            break;
        }

        case DLL_PROCESS_DETACH:
        {
            if (CommonControlsInitialized)
            {
                CommonControlsInitialized = FALSE;
                if (RichEditCtrlLib)
                {
                    FreeLibrary(RichEditCtrlLib);
                    RichEditCtrlLib = NULL;
                }
            }
        }

        case DLL_THREAD_ATTACH:
        case DLL_THREAD_DETACH:
            break;
    }
    return TRUE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
