// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/FilterManager/hctFilterDllManager.h>

/// This class verifies and loads any filter DLLs,
/// provides enumerated access to the individual filters,
/// and provides functions which operate on the set of DLL's as a whole
class hctFilterDllManagerImpl : public hctFilterDllManager
{
    public:

        // Constructor takes the path to where the filter DLLs are found,
        // and a class registry which is filled by the filters as required
        // The mem/singleton sync info can be null to just use the Dlls.
        hctFilterDllManagerImpl(hctFilterManagerInterface* filterInterface, const hkStringOld& filterPath, const hkMemoryInitUtil::SyncInfo* memSyncInfo  );
        ~hctFilterDllManagerImpl();

        // Access to the filter list
        virtual int getNumFilters() const HK_OVERRIDE { return m_filterDescs.getSize(); }
        virtual const hctFilterDescriptor* getFilterDescByIndex( int index ) const HK_OVERRIDE;
        virtual int getFilterIndexByID( unsigned int filterID ) const HK_OVERRIDE;

        // Applies these hctFilterDll functions to all filter DLLs
        void initThread( hkMemoryRouter* memRouter );

        // Tries to close and then waits for all modeless filters. Returns false if the user cancels
        bool closeAndWaitForModelessFilters(HWND parent) const;

        // Tell all modeless filters to close
        void askModelessFiltersToClose () const;

        // Returns how many modeless filters are present.
        int countModelessFilters (int& numActiveOut, int& numClosingout) const;

        // Silently waits for modeless filters
        void waitForModelessFilters() const;

    private:

        hkArray<hctFilterDll*> m_filterDlls;
        hkArray<const hctFilterDescriptor*> m_filterDescs;

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
