// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImpl.h>

extern HINSTANCE hInstance;

//
// Tree select
//


struct _TreeSelectData
{
    const char* title;
    hctTreeViewManager* tvManager;
    hkVariant selected;
};

INT_PTR CALLBACK hkFilterManagerTreeSelectProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    _TreeSelectData *data = reinterpret_cast<_TreeSelectData*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch (message)
    {
        case WM_INITDIALOG:
            if (lParam)
            {
                data = (_TreeSelectData*)lParam;
                SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

                if( data->title )
                {
                    SetWindowText(hWnd, data->title);
                }

                // Setup tree view
                HWND treeWnd = GetDlgItem( hWnd, IDC_SCENE_TREE );

                TreeView_SetBkColor( treeWnd, RGB(255,255,255) );
                HIMAGELIST hTreeImageList = ImageList_LoadImage( hInstance, MAKEINTRESOURCE(IDB_SCENENODES), 16, 1, RGB(255,255,255), IMAGE_BITMAP, LR_CREATEDIBSECTION );
                TreeView_SetImageList( treeWnd, hTreeImageList, TVSIL_NORMAL /*TVSIL_STATE*/);

                data->tvManager->init( treeWnd );
            }
            // FALL THROUGH to simulate resize

        case WM_SIZE:
            {
                RECT dialogRect;
                GetClientRect( hWnd, (LPRECT)&dialogRect );

                HWND treeWnd = GetDlgItem( hWnd, IDC_SCENE_TREE );
                SetWindowPos( treeWnd, NULL, 10, 10, dialogRect.right - 20, dialogRect.bottom - 55, SWP_NOZORDER );

                HWND okWnd = GetDlgItem( hWnd, IDOK );
                SetWindowPos( okWnd, NULL, (dialogRect.right/2) - 90, dialogRect.bottom - 35, 80, 25, SWP_NOZORDER );

                HWND cancelWnd = GetDlgItem( hWnd, IDCANCEL );
                SetWindowPos( cancelWnd, NULL, (dialogRect.right/2) + 10, dialogRect.bottom - 35, 80, 25, SWP_NOZORDER );
            }
            return TRUE;

        case WM_NOTIFY:
            {
                int idCtrl = (int)wParam;
                LPNMHDR pnmh = (LPNMHDR) lParam;

                switch (idCtrl)
                {
                    case IDC_SCENE_TREE: // Tree View of the scene
                    {
                        switch( pnmh->code )
                        {
                            case NM_DBLCLK:
                            case TVN_SELCHANGEDA:
                            case TVN_SELCHANGEDW: // EXP-2704 Handle Wide and Ascii treeview select
                            {
                                // check if the selection is returnable
                                hkVariant var;
                                bool valid = data->tvManager->getSelectedVariant( var );
                                valid = valid && var.getType() && data->tvManager->isSelectable( var );
                                if( valid )
                                {
                                    data->selected = var;
                                }

                                // allow exit only if valid
                                EnableWindow( GetDlgItem(hWnd, IDOK), valid );
                                if( valid && pnmh->code == NM_DBLCLK )
                                {
                                    EndDialog(hWnd, 1);
                                    return TRUE;
                                }
                            }
                            // FALL THROUGH

                            default:
                                if(data != HK_NULL)
                                {
                                    return data->tvManager->handleNotification( pnmh );
                                }
                        }
                    }
                }
            }
            break;

        case WM_COMMAND:
            switch (LOWORD(wParam))
            {
            case IDOK:
            case IDCANCEL:
                EndDialog( hWnd, LOWORD(wParam) == IDOK );
                return TRUE;
            }
            break;
    }
    return FALSE;
}

bool hctFilterManagerImpl::selectObjectFromTree( HWND owner, const char* title, class hctTreeViewManager* tvManager, hkVariant& selected ) const
{
    _TreeSelectData myData;
    myData.title = title;
    myData.tvManager = tvManager;

    INT_PTR retVal = DialogBoxParamW(hInstance, MAKEINTRESOURCEW(IDD_SELECT_NODE),
        owner, hkFilterManagerTreeSelectProc, (LPARAM)&myData);

    if( retVal > 0 )
    {
        selected = myData.selected;
        return true;
    }
    else
    {
        selected = hkReflect::Var();
        return false;
    }
}


//
// List select
//

struct _ListSelectData
{
    const char* title;
    hkArray< const char* > items;
    int selected;
};

INT_PTR CALLBACK hkFilterManagerListSelectProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    _ListSelectData *data = reinterpret_cast<_ListSelectData*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch( message )
    {
    case WM_INITDIALOG:
        {
            data = (_ListSelectData*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            if( data->title )
            {
                SetWindowText( hWnd, data->title );
            }

            HWND listBox = GetDlgItem(hWnd, IDC_LIST_ITEMS);
            int numItems = data->items.getSize();
            for( int i=0; i<numItems; ++i )
            {
                const char* item = data->items[i];
                SendMessage(listBox, LB_ADDSTRING, 0, (LPARAM) ( item? item : "<empty>") );
                SendMessage(listBox, LB_SETITEMDATA, i, (LPARAM) i);
            }
        }
        // FALL THROUGH to simulate resize

    case WM_SIZE:
        {
            RECT dialogRect;
            GetClientRect( hWnd, (LPRECT)&dialogRect );

            HWND treeWnd = GetDlgItem( hWnd, IDC_LIST_ITEMS );
            SetWindowPos( treeWnd, NULL, 10, 10, dialogRect.right - 20, dialogRect.bottom - 55, SWP_NOZORDER );

            HWND okWnd = GetDlgItem( hWnd, IDOK );
            SetWindowPos( okWnd, NULL, (dialogRect.right/2) - 90, dialogRect.bottom - 35, 80, 25, SWP_NOZORDER );

            HWND cancelWnd = GetDlgItem( hWnd, IDCANCEL );
            SetWindowPos( cancelWnd, NULL, (dialogRect.right/2) + 10, dialogRect.bottom - 35, 80, 25, SWP_NOZORDER );
        }
        return TRUE;

    case WM_COMMAND: // UI Changes
        {
            switch ( LOWORD(wParam) )
            {
            case IDC_LIST_ITEMS:
                switch (HIWORD(wParam))
                {
                case LBN_SELCHANGE:
                case LBN_DBLCLK:
                    {
                        HWND listBox = GetDlgItem(hWnd, IDC_LIST_ITEMS);
                        data->selected = (int)SendMessage(listBox, LB_GETCURSEL, 0, 0);

                        EnableWindow( GetDlgItem(hWnd, IDOK), data->selected != -1 );
                        if( HIWORD(wParam) == LBN_DBLCLK )
                        {
                            EndDialog(hWnd, TRUE);
                        }

                        return TRUE;
                    }
                }
                break;

            case IDOK:
                {
                    EndDialog(hWnd, TRUE);
                    return TRUE;
                }
            case IDCANCEL:
                {
                    data->selected = -1;
                    EndDialog(hWnd, FALSE);
                    return TRUE;
                }
            }
            break;
        }
    }
    return FALSE;
}

int hctFilterManagerImpl::selectItemFromList( HWND owner, const char* title, const hkArray< const char* >& items ) const
{
    _ListSelectData myData;
    myData.title = title;
    myData.items = items;
    myData.selected = -1;

    INT_PTR retVal = DialogBoxParamW(hInstance, MAKEINTRESOURCEW(IDD_SELECT_ITEM),
        owner, hkFilterManagerListSelectProc, (LPARAM)&myData);

    if( retVal > 0 )
    {
        return myData.selected;
    }
    else
    {
        return -1;
    }
}


//
// Show items
//

struct _ShowItemsData
{
    const char* title;
    hkArray< const char* > items;
};

INT_PTR CALLBACK hkFilterManagerShowItemsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    _ShowItemsData *data = reinterpret_cast<_ShowItemsData*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch( message )
    {
    case WM_INITDIALOG:
        {
            data = (_ShowItemsData*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            if( data->title )
            {
                SetWindowText( hWnd, data->title );
            }

            HWND listBox = GetDlgItem(hWnd, IDC_LIST_ITEMS);
            int numItems = data->items.getSize();
            for( int i=0; i<numItems; ++i )
            {
                const char* item = data->items[i];
                SendMessage(listBox, LB_ADDSTRING, 0, (LPARAM) ( item? item : "<empty>") );
            }
        }
        // FALL THROUGH to simulate resize

    case WM_SIZE:
        {
            RECT dialogRect;
            GetClientRect( hWnd, (LPRECT)&dialogRect );

            HWND treeWnd = GetDlgItem( hWnd, IDC_LIST_ITEMS );
            SetWindowPos( treeWnd, NULL, 10, 10, dialogRect.right - 20, dialogRect.bottom - 55, SWP_NOZORDER );

            HWND okWnd = GetDlgItem( hWnd, IDOK );
            SetWindowPos( okWnd, NULL, (dialogRect.right/2) - 40, dialogRect.bottom - 35, 80, 25, SWP_NOZORDER );
        }
        return TRUE;

    case WM_COMMAND:
        {
            switch ( LOWORD(wParam) )
            {
            case IDOK:
            case IDCANCEL:
                {
                    EndDialog(hWnd, TRUE);
                    return TRUE;
                }
            }
            break;
        }
    }
    return FALSE;
}

void hctFilterManagerImpl::showItems(HWND owner, const char* title, const hkArray< const char* >& items) const
{
    _ShowItemsData myData;
    myData.title = title;
    myData.items = items;

    DialogBoxParamW(hInstance, MAKEINTRESOURCEW(IDD_SHOW_ITEMS),
        owner, hkFilterManagerShowItemsProc, (LPARAM)&myData);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
