// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImpl.h>
#include <ContentTools/Common/Filters/Common/Error/hctFilterError.h>

extern HINSTANCE hInstance;

extern void _CloseCurrentFilterOptions( hctFilterManagerImpl* manager );
extern void _OpenFilterOptions( hctFilterManagerImpl* manager, int stageIndex );


INT_PTR CALLBACK hkFilterManagerProcessingProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctFilterManagerImpl *manager = reinterpret_cast<hctFilterManagerImpl*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch( message )
    {

    case WM_INITDIALOG:
        {
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later
            manager = (hctFilterManagerImpl*)lParam;

            // Clear logs
            CheckDlgButton( hWnd, IDC_CLEAR_LOG, BST_CHECKED );
        }
        // FALL THROUGH

    case WM_SIZE:
        {
            RECT wndRect; GetClientRect( hWnd, (LPRECT)&wndRect );

            SetWindowPos( GetDlgItem( hWnd, IDC_HEADING ), NULL,
                5, 5, wndRect.right-10, 15, SWP_NOZORDER );

            SetWindowPos( GetDlgItem( hWnd, IDC_PROGRESS_LOG ), NULL,
                5, 5, wndRect.right-10, wndRect.bottom-40, SWP_NOZORDER );

            SetWindowPos( GetDlgItem( hWnd, IDC_CLEAR_LOG ), NULL,
                5, wndRect.bottom-30, 0, 0, SWP_NOZORDER | SWP_NOSIZE );

            SetWindowPos( GetDlgItem( hWnd, IDC_RUN_ALL_CONFIGURATIONS ), NULL,
                wndRect.right-230, wndRect.bottom-30, 140, 25, SWP_NOZORDER );
            SetWindowPos( GetDlgItem( hWnd, IDC_CLOSE ), NULL,
                wndRect.right-85, wndRect.bottom-30, 80, 25, SWP_NOZORDER );

            InvalidateRect( hWnd, NULL, TRUE );
            UpdateWindow( hWnd );
        }
        break;

    case WM_COMMAND:
        {
            switch ( LOWORD(wParam) )
            {
                // Pass all close/cancel messages to the main window
                case IDC_CLOSE:
                    {
                        SendMessage( manager->m_mainWnd, WM_COMMAND, wParam, 0 );
                    }
                    break;

                case IDC_RUN_ALL_CONFIGURATIONS:
                    {
                        if( IsDlgButtonChecked(manager->m_processingWnd, IDC_CLEAR_LOG) == BST_CHECKED )
                        {
                            manager->m_errorHandler->clearLog();
                        }

                        _CloseCurrentFilterOptions( manager ); // in case it has options to be reflected


                        // Use the owner wnd, not this wnd, so that we can run multiple tests at one

                        manager->m_processMode = hctFilterManagerInterface::PROCESS_INTERACTIVE;
                        manager->processNoWait( manager->m_ownerWnd, -1, HK_NULL );
                        manager->m_processMode = hctFilterManagerInterface::PROCESS_NONE;

                        // Re-open the selected filter panel
                        {
                            HWND orderWnd = GetDlgItem(hWnd, IDC_FILTERS_ORDER_LIST);
                            int stageIndex = ListView_GetSelectionMark( orderWnd );
                            if( stageIndex >= 0 )
                            {
                                _OpenFilterOptions( manager, stageIndex );
                            }

                            SetFocus( orderWnd ); // so keys work and the dlg doesn't get the initial focus
                        }
                    }
                    break;
            }
        }
        break;

    }

    return FALSE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
