// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImpl.h>
#include <ContentTools/Common/Filters/FilterManager/DllManager/hctFilterDllManagerImpl.h>
#include <ContentTools/Common/Filters/Common/Error/hctFilterError.h>
#include <ContentTools/Common/Filters/Common/Options/hctFilterConfigurationSet.h>

extern HINSTANCE hInstance;


void _CloseCurrentFilterOptions( hctFilterManagerImpl* manager )
{
    hctFilterManagerImpl::FilterDialogInformation& dlgInfo = manager->m_currentFilterDialog;
    if (!dlgInfo.m_dlg)
    {
        return;
    }

    const hctFilterDescriptor* desc = manager->m_dllManager->getFilterDescByIndex(dlgInfo.m_filterIndex);
    hctFilterConfigurationSet::FilterStage& fsi = manager->m_configurationSet->getCurrentConfiguration().m_filterStages[ dlgInfo.m_stageIndex ];
    fsi.m_options.clear();

    dlgInfo.m_filter->hideOptions();
    dlgInfo.m_filter->getOptions(fsi.m_options);


    fsi.m_optionDataVersion = desc->getFilterVersion();

    // No need for the filter anymore.
    dlgInfo.m_filter->removeReference();

    // clear dlg info struct
    hkString::memSet(&dlgInfo, 0, sizeof(hctFilterManagerImpl::FilterDialogInformation));

    // reset the text above the options dlg
    SetWindowText( GetDlgItem( manager->m_optionsWnd, IDC_HEADING ), "Filter Options" );
}


void _updateOptionsScrollbar( hctFilterManagerImpl* manager, bool setPos, int pos )
{
    hctFilterManagerImpl::FilterDialogInformation& dlgInfo = manager->m_currentFilterDialog;

    RECT dialogRect;
    GetClientRect( dlgInfo.m_dlg, &dialogRect );
    int fullOptionsHeight = dialogRect.bottom + 20;

    RECT optionsRect;
    GetClientRect( manager->m_optionsWnd, &optionsRect );
    int fixedOptionsHeight = optionsRect.bottom;

    SCROLLINFO si; memset(&si, 0, sizeof(SCROLLINFO));
    si.cbSize = sizeof(SCROLLINFO);
    si.nPage = fixedOptionsHeight;
    si.nMin = 0;
    si.nMax = fullOptionsHeight;
    si.fMask = SIF_DISABLENOSCROLL | SIF_PAGE | SIF_RANGE;

    if (setPos)
    {
        si.fMask |= SIF_POS;
        si.nPos = pos;
    }

    SetScrollInfo( manager->m_optionsWnd, SB_VERT, &si, TRUE );
}


void _OpenFilterOptions( hctFilterManagerImpl* manager, int stageIndex )
{
    hctFilterManagerImpl::FilterDialogInformation& dlgInfo = manager->m_currentFilterDialog;
    if (dlgInfo.m_dlg)
    {
        _CloseCurrentFilterOptions( manager );
    }

    HWND headingWnd = GetDlgItem( manager->m_optionsWnd, IDC_HEADING );
    HWND optionsRectHwnd = GetDlgItem( manager->m_optionsWnd, IDC_OPTIONS_RECT );

    if ( (stageIndex >=0) && (stageIndex < manager->m_configurationSet->getCurrentConfiguration().m_filterStages.getSize()) )
    {
        hctFilterConfigurationSet::FilterStage& fsi = manager->m_configurationSet->getCurrentConfiguration().m_filterStages[stageIndex];
        const hctFilterDescriptor* desc = manager->m_dllManager->getFilterDescByIndex(fsi.m_index);

        // set this before showing flg so that it can use the 'run to current stage' for options
        dlgInfo.m_filterIndex = fsi.m_index;
        dlgInfo.m_stageIndex = stageIndex;

        hctFilterInterface* f = desc->createFilter(manager);
        dlgInfo.m_filter = f;

        // set the current options
        if ( fsi.m_options.var() )
        {
            f->setOptions( fsi.m_options.var() );
        }

        // bring up the filter options dialog to allow the user to set whatever it is the filter does
        HWND optionsDlg = f->showOptions( manager->m_optionsWnd );
        if (optionsDlg)
        {
            dlgInfo.m_dlg = optionsDlg;

            ShowWindow( optionsRectHwnd, SW_HIDE );
            SetWindowPos( optionsDlg, NULL, 0, 25, 0, 0, SWP_NOZORDER | SWP_NOSIZE );

            hkStringOld descText;
            descText.printf("%s @ stage%d", desc->getShortName(), (stageIndex + 1) );
            SetWindowText( headingWnd, descText.cString());

            // setup options dialog scrollbar
            _updateOptionsScrollbar(manager, false, 0);

            return; // done
        }
        else
        {
            f->removeReference();

            hkString::memSet(&dlgInfo, 0, sizeof(hctFilterManagerImpl::FilterDialogInformation));
        }
    }

    // no options at this stage
    SetWindowText( headingWnd, "Filter Options" );
    ShowWindow( optionsRectHwnd, SW_SHOW );
}


INT_PTR CALLBACK hkFilterManagerFilterOptionsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctFilterManagerImpl *manager = reinterpret_cast<hctFilterManagerImpl*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    static int yPos;        // current vertical scrolling position

    switch( message )
    {

        case WM_INITDIALOG:
            {
                SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later
                manager = (hctFilterManagerImpl*)lParam;
            }
            // FALL THROUGH

        case WM_SIZE:
            {
                RECT wndRect; GetClientRect( hWnd, (LPRECT)&wndRect );

                SetWindowPos( GetDlgItem( hWnd, IDC_HEADING ), NULL,
                    5, 5, wndRect.right - 10, 15, SWP_NOZORDER );

                SetWindowPos( GetDlgItem( hWnd, IDC_OPTIONS_RECT ), NULL,
                    0, 25, wndRect.right, wndRect.bottom - 25, SWP_NOZORDER );

                InvalidateRect( hWnd, NULL, TRUE );
                UpdateWindow( hWnd );

                // scroll options window so its top is at top of window, on window resizing
                SCROLLINFO si; memset(&si, 0, sizeof(SCROLLINFO));
                si.cbSize = sizeof (si);
                si.fMask = SIF_POS;
                GetScrollInfo (hWnd, SB_VERT, &si);
                ScrollWindow(hWnd, 0, si.nPos, NULL, NULL);

                // move scrollbar to home position, on window resizing
                _updateOptionsScrollbar(manager, true, 0);

            }
            break;

        // filter options scrollbar events
        case WM_VSCROLL:
            {
                SCROLLINFO si; memset(&si, 0, sizeof(SCROLLINFO));

                si.cbSize = sizeof (si);
                si.fMask  = SIF_ALL;
                GetScrollInfo (hWnd, SB_VERT, &si);
                // Save the position for comparison later on
                yPos = si.nPos;

                switch( LOWORD (wParam) )
                {
                    // user dragged the scroll box
                    case SB_THUMBTRACK:
                        si.nPos = si.nTrackPos;
                        break;

                    default:
                        break;
                }

                // Set the position and then retrieve it.  Due to adjustments
                // by Windows it may not be the same as the value set.
                si.fMask = SIF_POS;
                SetScrollInfo (hWnd, SB_VERT, &si, TRUE);
                GetScrollInfo (hWnd, SB_VERT, &si);

                // If the position has changed, scroll window and update it
                if (si.nPos != yPos)
                {
                    ScrollWindow(hWnd, 0, (yPos - si.nPos), NULL, NULL);
                    UpdateWindow(hWnd);
                }
            }
            break;

    }

    return FALSE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
