// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterManager/hctFilterManager.h>
#include <ContentTools/Common/Filters/FilterManager/hctFilterManagerImpl.h>
#include <ContentTools/Common/Filters/FilterManager/DllManager/hctFilterDllManagerImpl.h>


extern HINSTANCE hInstance;

extern hctFilterDescriptor::FilterCategory _tabToCategory (int tabIdx);
extern int _categoryToTab (hctFilterDescriptor::FilterCategory category);
extern void _FillCategory( hctFilterManagerImpl* manager, hctFilterDescriptor::FilterCategory cat, HWND listWnd);


INT_PTR CALLBACK hkFilterManagerAvailableFiltersProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctFilterManagerImpl *manager = reinterpret_cast<hctFilterManagerImpl*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch( message )
    {

    case WM_INITDIALOG:
        {
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later
            manager = (hctFilterManagerImpl*)lParam;

            // Setup tabs
            HWND tabWnd = GetDlgItem( hWnd, IDC_CAT_TAB );
            {
                HIMAGELIST hImageListCat = ImageList_LoadImage( hInstance, MAKEINTRESOURCE(IDB_BITMAP_CAT), 16, 1, RGB(255,255,255),
                                                                IMAGE_BITMAP, LR_CREATEDIBSECTION );
                TabCtrl_SetImageList( tabWnd, hImageListCat );

                TCITEM tie;
                tie.mask = TCIF_IMAGE | TCIF_TEXT;
                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_CORE);
                tie.pszText = "Core";
                TabCtrl_InsertItem(tabWnd, 0, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_PHYSICS_2012);
                tie.pszText = "Physics";
                TabCtrl_InsertItem(tabWnd, 1, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_ANIMATION);
                tie.pszText = "Animation";
                TabCtrl_InsertItem(tabWnd, 2, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_CLOTH);
                tie.pszText = "Cloth";
                TabCtrl_InsertItem(tabWnd, 3, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_DESTRUCTION_2012);
                tie.pszText = "Destruction";
                TabCtrl_InsertItem(tabWnd, 4, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_GRAPHICS);
                tie.pszText = "Graphics";
                TabCtrl_InsertItem(tabWnd, 5, &tie);

                tie.iImage = manager->categoryToIconID(hctFilterDescriptor::HK_CATEGORY_USER);
                tie.pszText = "User";
                TabCtrl_InsertItem(tabWnd, 6, &tie);
            }

            // Setup list
            HWND listWnd = GetDlgItem( hWnd, IDC_FILTERS_LIST );
            {
                DWORD style = LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_INFOTIP;
                SendMessage(listWnd,LVM_SETEXTENDEDLISTVIEWSTYLE,0,style);

                LVCOLUMN LvCol;
                LvCol.mask = LVCF_TEXT;
                LvCol.pszText = "Filter Name";
                ListView_InsertColumn( listWnd, 0, &LvCol );
                LvCol.pszText = "Version";
                ListView_InsertColumn( listWnd, 1, &LvCol );
            }

            // Set initial tab and list contents
            TabCtrl_SetCurSel( tabWnd, _categoryToTab(hctFilterDescriptor::HK_CATEGORY_CORE) );
            _FillCategory( manager, hctFilterDescriptor::HK_CATEGORY_CORE, listWnd );
        }
        // FALL THROUGH

    case WM_SIZE:
        {
            RECT wndRect; GetClientRect( hWnd, (LPRECT)&wndRect );

            SetWindowPos( GetDlgItem( hWnd, IDC_HEADING ), NULL,
                5, 5, wndRect.right-10, 15, SWP_NOZORDER );

            SetWindowPos( GetDlgItem( hWnd, IDC_CAT_TAB ), NULL,
                5, 25, wndRect.right-10, wndRect.bottom-30, SWP_NOZORDER );

            HWND listWnd = GetDlgItem( hWnd, IDC_FILTERS_LIST );
            SetWindowPos( listWnd, NULL,
                10, 75, wndRect.right-20, wndRect.bottom-85, SWP_NOZORDER );

            LVCOLUMN LvCol;
            LvCol.mask = LVCF_WIDTH;
            RECT listRect; GetClientRect( listWnd, &listRect );
            LvCol.cx = int(listRect.right * 0.75f);
            ListView_SetColumn( listWnd, 0, &LvCol );
            LvCol.cx = int(listRect.right * 0.25f);
            ListView_SetColumn( listWnd, 1, &LvCol );

            InvalidateRect( hWnd, NULL, TRUE );
            UpdateWindow( hWnd );
        }
        break;

    case WM_NOTIFY:
        {
            LPNMHDR pnmh = (LPNMHDR)lParam;
            switch( wParam )
            {

            case IDC_CAT_TAB:
                {
                    switch( pnmh->code )
                    {
                    case TCN_SELCHANGE:
                        {
                            HWND tabWnd = GetDlgItem(hWnd, IDC_CAT_TAB);
                            HWND listWnd = GetDlgItem(hWnd, IDC_FILTERS_LIST);
                            _FillCategory( manager, _tabToCategory( TabCtrl_GetCurSel(tabWnd) ), listWnd );
                        }
                        break;
                    }
                }
                break;

            case IDC_FILTERS_LIST:
                {
                    switch( pnmh->code )
                    {
                    case NM_DBLCLK:
                        {
                            SendMessage( manager->m_configurationWnd, WM_COMMAND, IDC_FILTER_INSERT, 0 );
                            break;
                        }
                    case LVN_GETINFOTIP:
                        {
                            LPNMLVGETINFOTIP lplvgit = (LPNMLVGETINFOTIP)pnmh;

                            LVITEM LvItem;
                            LvItem.iItem = lplvgit->iItem;
                            LvItem.mask = LVIF_PARAM;
                            ListView_GetItem( pnmh->hwndFrom, &LvItem );

                            const hctFilterDescriptor* desc = manager->m_dllManager->getFilterDescByIndex( (int)( LvItem.lParam ) );
                            const hctFilterDescriptor::HavokComponentMask requiredComponents = desc->getRequiredHavokComponents();

                            if( manager->checkProductSupport(requiredComponents))
                            {
                                lplvgit->pszText = const_cast<LPSTR>( desc->getLongName() );
                            }
                            else
                            {
                                lplvgit->pszText = "This filter is not supported by the current product selection";
                            }
                            break;
                        }
                    case NM_CUSTOMDRAW:
                        {
                            LPNMLVCUSTOMDRAW lplvcd = (LPNMLVCUSTOMDRAW)pnmh;
                            switch( lplvcd->nmcd.dwDrawStage )
                            {

                            case CDDS_PREPAINT:
                                SetWindowLong(hWnd, DWLP_MSGRESULT, CDRF_NOTIFYITEMDRAW);
                                return TRUE;

                            case CDDS_ITEMPREPAINT:
                                {
                                    LVITEM LvItem;
                                    LvItem.iItem = (int) lplvcd->nmcd.dwItemSpec;
                                    LvItem.mask = LVIF_PARAM;
                                    ListView_GetItem( pnmh->hwndFrom, &LvItem );

                                    const hctFilterDescriptor* desc = manager->m_dllManager->getFilterDescByIndex( (int)( LvItem.lParam ) );
                                    const hctFilterDescriptor::HavokComponentMask requiredComponents = desc->getRequiredHavokComponents();

                                    lplvcd->clrText = manager->checkProductSupport(requiredComponents) ? RGB(0,0,0): RGB(200,20,20);
                                    SetWindowLong(hWnd, DWLP_MSGRESULT, CDRF_NEWFONT );
                                }
                                return TRUE;

                            }
                        }
                        break;

                    }
                }
                break;

            }
        }
        break;

    }
    return FALSE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
