// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterAsset/hctFilterAsset.h>

#include <ContentTools/Common/Filters/FilterAsset/hctFilterAssetDll.h>

// Filters we want to expose in this dll:
#include <ContentTools/Common/Filters/FilterAsset/PruneTypes/hctPruneTypesFilter.h>
#include <ContentTools/Common/Filters/FilterAsset/MergeAsset/hctMergeAssetFilter.h>


// The libraries that are not linked have already been excluded
// from the project configuration, even if the keycodes are
// present

// Enables features based on what product's keycodes are defined
// Needs the version patches, but exclude the reflected classes
#include <Common\Base\KeyCode.h>
#undef HK_FEATURE_REFLECTION_BEHAVIOR
#undef HK_FEATURE_REFLECTION_DESTRUCTION_2012
#undef HK_FEATURE_REFLECTION_AI
#undef HK_FEATURE_REFLECTION_CLOTH
#undef HK_FEATURE_PRODUCT_DESTRUCTION
#undef HK_FEATURE_PRODUCT_PHYSICS //todo.nt6
#define HK_EXCLUDE_FEATURE_MemoryTracker
#define HK_EXCLUDE_FEATURE_SerializeDeprecatedPre700
#define HK_EXCLUDE_LIBRARY_hkVisualize
#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#define HK_EXCLUDE_FEATURE_RegisterVersionPatches
#define HK_EXCLUDE_FEATURE_hkFormatYamlFile
#include <Common/Base/Config/hkProductFeatures.cxx>

#if defined (HK_FEATURE_PRODUCT_PHYSICS_2012)
#include <Physics2012/Collide/Util/Welding/hkpWeldingUtility.h>
#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>
#endif

__declspec( dllexport ) hctFilterDll* getFilterDll (HMODULE dllModule)
{
    static hctFilterAssetDll gFilterAssetDll (dllModule);

    return &gFilterAssetDll;
}

hctFilterAssetDll::hctFilterAssetDll (HMODULE dllModule) : hctFilterDll (dllModule)
{

}

/*virtual*/ int hctFilterAssetDll::getNumberOfFilters() const
{
    return 2;
}

/*virtual*/ hctFilterDescriptor* hctFilterAssetDll::getFilterDescriptor (int index) const
{
    static hctFilterDescriptor* m_filterDescs[] =
    {
        &g_pruneTypesDesc,
        &g_mergeAssetDesc,
    };

    return m_filterDescs[index];
}

/*virtual*/ void hctFilterAssetDll::initDll ( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream )
{
    hctFilterDll::initDll(baseSystemInfo, errorStream);

#if defined (HK_FEATURE_PRODUCT_PHYSICS_2012)
    // HVK-3632
    if (isInitialized())
    {
        hkpWorldCinfo defaults;
        hkpWeldingUtility::initWeldingTable(defaults.m_snapCollisionToConvexEdgeThreshold, defaults.m_snapCollisionToConcaveEdgeThreshold);
    }
#endif
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
