// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// Options describing what types to prune.
class hctPruneTypesOptions
{
public:
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_EXPORT, hctPruneTypesOptions );
    HK_DECLARE_REFLECTION();

    hctPruneTypesOptions();

    /// Remove scene info types (nodes, cameras)
    hkBool m_pruneSceneData;//+default(true)

    /// Remove mesh types (blended mesh etc)
    hkBool m_pruneMeshData;

    /// Remove skeleton types (skeleton, bone)
    hkBool m_pruneSkeletonData;

    /// Remove animation types (tracks, skeletal animation, bindings, etc)
    hkBool m_pruneAnimationData;

    /// A list of the custom classes to remove, separated by semicolons
    hkStringPtr m_customClasses;

    /// Remove all scene data
    hkBool m_pruneAllSceneData; //+default(false)

    /// Remove environment data
    hkBool m_pruneEnvironmentData; //+default(false)

    /// Remove all Resource data
    hkBool m_pruneResourceData; //+default(false)

    /// Remove Destruction data
    hkBool m_pruneDestructionData; //+default(false)

    /// Remove animation tracks
    hkBool m_pruneAnimationTracks; //+default(false)

    /// Remove annotations
    hkBool m_pruneAnnotations; //+default(false)

    /// Remove identity binding indices
    hkBool m_pruneIdentityBindingIndices; //+default(false)

    /// Remove bindings for quantized and predictive animations
    hkBool m_pruneQuantizedBindings; //+default(false)

    /// Remove node attributes
    hkBool m_pruneAttributes; //+default(false)

    /// Remove mesh user channels
    hkBool m_pruneMeshUserChannels; //+default(false)

    /// Remove attachments
    hkBool m_pruneAttachments; //+default(false)

    enum selectionDeletionMode
    {
        ///
        HK_SELECTION_DELETE_SELECTED = 1,
        ///
        HK_SELECTION_DELETE_NOT_SELECTED
    };

    /// Remove node selection sets
    hkBool m_pruneSelectionSets;

    /// A list of the selection sets to remove, separated by semicolons
    hkStringPtr m_selectionSets;

    hkEnum<selectionDeletionMode, hkInt8> m_selectionDeletionMode;

    /// Remove all animation data
    hkBool m_pruneAllAnimationData; //+default(false)

    /// Remove mesh bindings data
    hkBool m_pruneMeshBindingData; //+default(false)

    /// Remove mesh bindings data
    hkBool m_pruneRagdollAndMapperData; //+default(false)

};

HK_REFLECT_ENUM(/**/, hctPruneTypesOptions::selectionDeletionMode);

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
