// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterAsset/hctFilterAsset.h>
#include <ContentTools/Common/Filters/FilterAsset/PruneTypes/hctPruneTypesFilter.h>
#include <Common/SceneData/Selection/hkxNodeSelectionSet.h>

extern HINSTANCE hInstance;

void hctPruneTypesFilter::setDataFromControls()
{
    m_options.m_pruneSceneData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_SceneData) != FALSE;
    m_options.m_pruneMeshData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_MeshData) != FALSE;
    m_options.m_pruneSkeletonData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_SkeletonData) != FALSE;
    m_options.m_pruneAnimationData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_AnimationData) != FALSE;
    m_options.m_pruneAllSceneData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_AllSceneData) != FALSE;
    m_options.m_pruneEnvironmentData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_Environment) != FALSE;
    m_options.m_pruneResourceData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_ResourceData) != FALSE;
    m_options.m_pruneDestructionData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_DestructionData) != FALSE;
    m_options.m_pruneAnimationTracks = IsDlgButtonChecked(m_optionsDialog, IDC_CB_AnimationTracks) != FALSE;
    m_options.m_pruneAnnotations = IsDlgButtonChecked(m_optionsDialog, IDC_CB_Annotations) != FALSE;
    m_options.m_pruneIdentityBindingIndices = IsDlgButtonChecked(m_optionsDialog, IDC_CB_IdentityBindings) != FALSE;
    m_options.m_pruneQuantizedBindings = IsDlgButtonChecked(m_optionsDialog, IDC_CB_QuantizedBindings) != FALSE;
    m_options.m_pruneMeshUserChannels = IsDlgButtonChecked(m_optionsDialog, IDC_CB_MeshUserChannels) != FALSE;
    m_options.m_pruneAttributes = IsDlgButtonChecked(m_optionsDialog, IDC_CB_NodeAttributes) != FALSE;
    m_options.m_pruneAttachments = IsDlgButtonChecked(m_optionsDialog, IDC_CB_Attachments) != FALSE;
    m_options.m_pruneSelectionSets = IsDlgButtonChecked(m_optionsDialog, IDC_CB_NodeSelections) != FALSE;

    m_options.m_pruneAllAnimationData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_AllAnimationData) != FALSE;
    m_options.m_pruneMeshBindingData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_MeshBindings) != FALSE;
    m_options.m_pruneRagdollAndMapperData = IsDlgButtonChecked(m_optionsDialog, IDC_CB_RagdollMappers) != FALSE;

    // Store list of selected custom classes
    HWND hWndList_CCT = GetDlgItem(m_optionsDialog, IDC_CCT_LIST);
    m_customClasses = "";
    for(int i=0; i<ListView_GetItemCount(hWndList_CCT); ++i)
    {
        TCHAR buf[MAX_PATH];
        ListView_GetItemText(hWndList_CCT, i, 0, buf, MAX_PATH);

        if(i>0) m_customClasses += ";";
        m_customClasses += buf;
    }
    m_options.m_customClasses = const_cast<char*>(m_customClasses.cString());

    // Store list of selected selection-sets
    HWND hWndList_SS = GetDlgItem(m_optionsDialog, IDC_SS_LIST);
    m_selectionSets = "";
    for(int i=0; i<ListView_GetItemCount(hWndList_SS); ++i)
    {
        TCHAR buf[MAX_PATH];
        ListView_GetItemText(hWndList_SS, i, 0, buf, MAX_PATH);

        if(i>0) m_selectionSets += ";";
        m_selectionSets += buf;
    }
    m_options.m_selectionSets = const_cast<char*>(m_selectionSets.cString());

    setControlsFromData();
}

void hctPruneTypesFilter::setControlsFromData()
{
    m_fillingControls = true;
    {
        CheckDlgButton(m_optionsDialog, IDC_CB_SceneData, m_options.m_pruneSceneData );
        CheckDlgButton(m_optionsDialog, IDC_CB_MeshData, m_options.m_pruneMeshData );
        CheckDlgButton(m_optionsDialog, IDC_CB_SkeletonData, m_options.m_pruneSkeletonData );
        CheckDlgButton(m_optionsDialog, IDC_CB_AnimationData, m_options.m_pruneAnimationData );
        CheckDlgButton(m_optionsDialog, IDC_CB_AllSceneData, m_options.m_pruneAllSceneData );
        CheckDlgButton(m_optionsDialog, IDC_CB_Environment, m_options.m_pruneEnvironmentData );
        CheckDlgButton(m_optionsDialog, IDC_CB_ResourceData, m_options.m_pruneResourceData );
        CheckDlgButton(m_optionsDialog, IDC_CB_DestructionData, m_options.m_pruneDestructionData );
        CheckDlgButton(m_optionsDialog, IDC_CB_AnimationTracks, m_options.m_pruneAnimationTracks );
        CheckDlgButton(m_optionsDialog, IDC_CB_Annotations, m_options.m_pruneAnnotations);
        CheckDlgButton(m_optionsDialog, IDC_CB_IdentityBindings, m_options.m_pruneIdentityBindingIndices);
        CheckDlgButton(m_optionsDialog, IDC_CB_QuantizedBindings, m_options.m_pruneQuantizedBindings);
        CheckDlgButton(m_optionsDialog, IDC_CB_MeshUserChannels, m_options.m_pruneMeshUserChannels );
        CheckDlgButton(m_optionsDialog, IDC_CB_NodeAttributes, m_options.m_pruneAttributes);
        CheckDlgButton(m_optionsDialog, IDC_CB_Attachments, m_options.m_pruneAttachments);
        CheckDlgButton(m_optionsDialog, IDC_CB_NodeSelections, m_options.m_pruneSelectionSets);
        CheckDlgButton(m_optionsDialog, IDC_CB_AllAnimationData, m_options.m_pruneAllAnimationData);
        CheckDlgButton(m_optionsDialog, IDC_CB_MeshBindings, m_options.m_pruneMeshBindingData);
        CheckDlgButton(m_optionsDialog, IDC_CB_RagdollMappers, m_options.m_pruneRagdollAndMapperData);

        // set selection-set deletion mode radio button from options
        int rbToCheck;
        switch (m_options.m_selectionDeletionMode)
        {
        case hctPruneTypesOptions::HK_SELECTION_DELETE_SELECTED:
            {
                rbToCheck = IDC_RB_DELETE_SETS;
                break;
            }
        case hctPruneTypesOptions::HK_SELECTION_DELETE_NOT_SELECTED:
            {
                rbToCheck = IDC_RB_RETAIN_SETS;
                break;
            }
        default:
            {
                // Invalid options, set it to delete selected
                rbToCheck = IDC_RB_DELETE_SETS;
                m_options.m_selectionDeletionMode = hctPruneTypesOptions::HK_SELECTION_DELETE_SELECTED;
                break;
            }
        }
        CheckRadioButton(m_optionsDialog, IDC_RB_DELETE_SETS, IDC_RB_RETAIN_SETS, rbToCheck);

        // Disable some checkboxes
        {
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_SceneData), !m_options.m_pruneAllSceneData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_NodeAttributes), !(m_options.m_pruneAllSceneData||m_options.m_pruneSceneData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_NodeSelections), !(m_options.m_pruneAllSceneData||m_options.m_pruneSceneData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_MeshUserChannels), !(m_options.m_pruneAllSceneData || m_options.m_pruneMeshData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_MeshData), !m_options.m_pruneAllSceneData);

            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_SkeletonData), !m_options.m_pruneAllAnimationData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_Attachments), !m_options.m_pruneAllAnimationData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_AnimationData), !m_options.m_pruneAllAnimationData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_AnimationTracks), !(m_options.m_pruneAllAnimationData||m_options.m_pruneAnimationData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_Annotations), !(m_options.m_pruneAllAnimationData||m_options.m_pruneAnimationData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_IdentityBindings), !(m_options.m_pruneAllAnimationData||m_options.m_pruneAnimationData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_QuantizedBindings), !(m_options.m_pruneAllAnimationData||m_options.m_pruneAnimationData));
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_MeshBindings), !m_options.m_pruneAllAnimationData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_RagdollMappers), !m_options.m_pruneAllAnimationData);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_DestructionData), !m_options.m_pruneResourceData);

#if !defined(HK_FEATURE_PRODUCT_ANIMATION)
            // Grey out all the checkboxes
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_AllAnimationData), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_SkeletonData), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_Attachments), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_AnimationData), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_AnimationTracks), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_Annotations), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_IdentityBindings), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_QuantizedBindings), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_MeshBindings), false);
            EnableWindow(GetDlgItem(m_optionsDialog, IDC_CB_RagdollMappers), false);
#endif
        }

        // Fill custom classes UI from stored options
        HWND hWndList_CCT = GetDlgItem(m_optionsDialog, IDC_CCT_LIST);
        ListView_DeleteAllItems(hWndList_CCT);

        LVITEM LvItem;
        memset(&LvItem, 0, sizeof(LvItem)); // Reset Item Struct
        LvItem.mask = LVIF_TEXT;   // Text Style
        LvItem.cchTextMax = MAX_PATH; // Max size of test
        const char* classes = m_options.m_customClasses;
        if(classes)
        {
            int i=0, j=0, k=0;
            while (classes[j])
            {
                i = j;
                while (classes[i] && (classes[i] != ';'))
                {
                    ++i;
                }

                if ((i - j) > 0)
                {
                    hkStringOld str(&classes[j], i-j);
                    LvItem.iItem = k++;
                    LvItem.pszText = const_cast<TCHAR*>( TEXT( str.cString() ) );
                    ListView_InsertItem(hWndList_CCT, &LvItem);
                }
                j = classes[i] ? i + 1 : i;
            }
        }

        // Fill selection sets UI from stored options
        HWND hWndList_SS = GetDlgItem(m_optionsDialog, IDC_SS_LIST);
        ListView_DeleteAllItems(hWndList_SS);

        memset(&LvItem, 0, sizeof(LvItem)); // Reset Item Struct
        LvItem.mask = LVIF_TEXT;   // Text Style
        LvItem.cchTextMax = MAX_PATH; // Max size of test
        const char* sets = m_options.m_selectionSets;
        if(sets)
        {
            int i=0, j=0, k=0;
            while (sets[j])
            {
                i = j;
                while (sets[i] && (sets[i] != ';'))
                {
                    ++i;
                }

                if ((i - j) > 0)
                {
                    hkStringOld str(&sets[j], i-j);
                    LvItem.iItem = k++;
                    LvItem.pszText = const_cast<TCHAR*>( TEXT( str.cString() ) );
                    ListView_InsertItem(hWndList_SS, &LvItem);
                }
                j = sets[i] ? i + 1 : i;
            }
        }

        // Enable/Disable selection set UI
        hkBool enableSelectionSetUI = !m_options.m_pruneAllSceneData && !m_options.m_pruneSceneData && !m_options.m_pruneSelectionSets;
        EnableWindow(hWndList_SS, enableSelectionSetUI);
        EnableWindow( GetDlgItem(m_optionsDialog, IDC_SS_PICK), enableSelectionSetUI );
        EnableWindow( GetDlgItem(m_optionsDialog, IDC_SS_DELETE), enableSelectionSetUI );
        EnableWindow( GetDlgItem(m_optionsDialog, IDC_RB_DELETE_SETS), enableSelectionSetUI );
        EnableWindow( GetDlgItem(m_optionsDialog, IDC_RB_RETAIN_SETS), enableSelectionSetUI );
    }

    m_fillingControls = false;
}


void _discoverSelectionSets( const hkRootLevelContainer* data, hkArray<hkxNodeSelectionSet*>& sets )
{
    hkxScene* scenePtr = data->findObject<hkxScene>();

    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS (0xabbab3e1, "No scene data found");
        return;
    }

    for (int i=0; i<scenePtr->m_selectionSets.getSize(); ++i)
    {
        hkxNodeSelectionSet* set = scenePtr->m_selectionSets[i];
        sets.pushBack(set);
    }
}


INT_PTR CALLBACK hkPruneTypesFilterDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctPruneTypesFilter* filter = reinterpret_cast<hctPruneTypesFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filter = (hctPruneTypesFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            filter->m_optionsDialog = hWnd;

            // Init options
            filter->setControlsFromData();

            // Initialize Tool Tips
            {
                CreateToolTip(IDC_CB_AllSceneData, hWnd, hInstance, "If enabled, fully removes the hkxScene object.");
                CreateToolTip(IDC_CB_SceneData, hWnd, hInstance, "If enabled, removes nodes, lights, cameras, materials and textures, retaining some basic scene information.");
                CreateToolTip(IDC_CB_NodeAttributes, hWnd, hInstance, "If enabled, removes all attributes associated to nodes (hkxNode).");
                CreateToolTip(IDC_CB_NodeSelections, hWnd, hInstance, "If enabled, removes all node selection sets.");
                CreateToolTip(IDC_CB_MeshData, hWnd, hInstance, "If enabled, removes mesh data (meshes and skin bindings).");
                CreateToolTip(IDC_CB_MeshUserChannels, hWnd, hInstance, "If enabled, removes any vertex / triangle selection data associated to meshes.");
                CreateToolTip(IDC_CB_SkeletonData, hWnd, hInstance, "If enabled, removes any skeletons (hkaSkeleton objects).");
                CreateToolTip(IDC_CB_Attachments, hWnd, hInstance, "If enabled, remove any bone attachments (hkaBoneAttachment objects).");
                CreateToolTip(IDC_CB_AnimationData, hWnd, hInstance, "If enabled, removes any animations (hkaAnimation objects) and their associated bindings.");
                CreateToolTip(IDC_CB_AnimationTracks, hWnd, hInstance, "If enabled, removes track names from the animations. Do not check this option if you plan to bind animations to skeletons at run-time (since track names are required to do so).");
                CreateToolTip(IDC_CB_Annotations, hWnd, hInstance, "If enabled, removes annotations from the animations.");
                CreateToolTip(IDC_CB_IdentityBindings, hWnd, hInstance, "If enabled, removes the index arrays of a binding if the mapping is equivalent to the identity (but keeps the binding). At runtime these arrays will be implicitly read as if they were an identity mapping.");
                CreateToolTip(IDC_CB_QuantizedBindings, hWnd, hInstance, "If enabled, completely removes the hkaAnimationBinding instances associated with instances of hkaQuantizedAnimation and hkaPredictiveCompressedAnimation");
                CreateToolTip(IDC_CB_Environment, hWnd, hInstance, "If enabled, removes any hkxEnvironment object. Note that these objects are ignored by the Platform Writer filter, so it is usually not necessary to prune them.");
                CreateToolTip(IDC_CB_ResourceData, hWnd, hInstance, "If enabled, removes the full Resource Data subtree.");
                CreateToolTip(IDC_CB_DestructionData, hWnd, hInstance, "If enabled, removes any Destruction related object.");
                CreateToolTip(IDC_SS_LIST, hWnd, hInstance, "");
                CreateToolTip(IDC_RB_DELETE_SETS, hWnd, hInstance, "");
                CreateToolTip(IDC_RB_RETAIN_SETS, hWnd, hInstance, "");
                CreateToolTip(IDC_CCT_EDIT, hWnd, hInstance, "Add a list of custom type names (like hkpPhysicsData or hkaRagdollInstance). The filter will remove any objects of the given types found inside the named variants at root level.");
                CreateToolTip(IDC_CCT_LIST, hWnd, hInstance, "");

                CreateToolTip(IDC_CB_AllAnimationData, hWnd, hInstance, "If enabled, fully removes the hkaAnimationContainer object.");
                CreateToolTip(IDC_CB_MeshBindings, hWnd, hInstance, "If enabled, removes mesh binding data (hkaMeshBinding objects).");
                CreateToolTip(IDC_CB_RagdollMappers, hWnd, hInstance, "If enabled, removes ragdoll and mapping data (hkaRagdollInstance and hkaSkeletonMapper objects).");
            }

            return TRUE; // did handle it
        }
        case WM_COMMAND: // UI Changes
        {
            // Avoid recursion
            if (!filter->m_fillingControls)
            {
                switch ( LOWORD(wParam) )
                {
                    // Custom classes interface
                    case IDC_CCT_ADD:
                    {
                        HWND hWndList = GetDlgItem(hWnd, IDC_CCT_LIST);

                        // Get text from edit box. As a class name, we can keep as Ascii only
                        char item[MAX_PATH];
                        item[0] = '\0';
                        GetDlgItemTextA(hWnd, IDC_CCT_EDIT, item, MAX_PATH);
                        SetDlgItemTextA(hWnd, IDC_CCT_EDIT, "");

                        // Break if empty or exists already
                        if( item[0] == '\0') break;
                        LVFINDINFOA LvFindItem;
                        memset(&LvFindItem, 0, sizeof(LvFindItem)); // Reset Item Struct
                        LvFindItem.flags = LVFI_STRING;
                        LvFindItem.psz = item;
                        if( ListView_FindItem(hWndList, -1, &LvFindItem) != -1 ) break;

                        // Add it to the list
                        LVITEMA LvSetItem;
                        memset(&LvSetItem, 0, sizeof(LvFindItem)); // Reset Item Struct
                        LvSetItem.mask = LVIF_TEXT;   // Text Style with param index number
                        LvSetItem.cchTextMax = MAX_PATH; // Max size of test
                        LvSetItem.iItem = ListView_GetItemCount(hWndList);
                        LvSetItem.pszText = item;
                        ListView_InsertItem(hWndList, &LvSetItem);
                    }
                    break;

                    case IDC_CCT_DELETE:
                    {
                        // Delete selected items from the list
                        HWND hWndList = GetDlgItem(hWnd, IDC_CCT_LIST);
                        for(int i=0; i<ListView_GetItemCount(hWndList); ++i)
                        {
                            if( ListView_GetItemState(hWndList, i, LVIS_SELECTED) )
                            {
                                ListView_DeleteItem(hWndList, i);
                                --i;
                            }
                        }
                    }
                    break;

                    // Selection sets interface
                    case IDC_SS_PICK:
                    {
                        HWND hWndList = GetDlgItem(hWnd, IDC_SS_LIST);

                        // Discover selection sets
                        hkArray<hkxNodeSelectionSet*> sets;
                        {
                            const hkRootLevelContainer* data = filter->getFilterManager()->getOriginalContents();
                            _discoverSelectionSets(data, sets);
                        }

                        // Pick a selection set
                        hkxNodeSelectionSet* s = NULL;
                        {
                            hkArray< const char* > items;
                            for( int i=0; i<sets.getSize(); ++i )
                            {
                                items.pushBack( sets[i]->m_name );
                            }
                            int index = filter->getFilterManager()->selectItemFromList( hWnd, "Pick a Selection Set", items );
                            if( index >= 0 && index < sets.getSize() )
                            {
                                s = sets[index];
                            }
                        }

                        if (s)
                        {
                            const char* item = s->m_name.cString();

                            // Break if empty or exists already
                            if( hkString::strLen(item) == 0) break;
                            LVFINDINFO LvFindItem;
                            memset(&LvFindItem, 0, sizeof(LvFindItem)); // Reset Item Struct
                            LvFindItem.flags = LVFI_STRING;
                            LvFindItem.psz = item;
                            if( ListView_FindItem(hWndList, -1, &LvFindItem) != -1 ) break;

                            // Add it to the list
                            LVITEM LvSetItem;
                            memset(&LvSetItem, 0, sizeof(LvFindItem)); // Reset Item Struct
                            LvSetItem.mask = LVIF_TEXT;   // Text Style with param index number
                            LvSetItem.cchTextMax = MAX_PATH; // Max size of test
                            LvSetItem.iItem = ListView_GetItemCount(hWndList);
                            LvSetItem.pszText = (LPSTR)item;
                            ListView_InsertItem(hWndList, &LvSetItem);
                        }
                    }
                    break;

                    case IDC_SS_DELETE:
                    {
                        // Delete selected items from the list
                        HWND hWndList = GetDlgItem(hWnd, IDC_SS_LIST);
                        for(int i=0; i<ListView_GetItemCount(hWndList); ++i)
                        {
                            if( ListView_GetItemState(hWndList, i, LVIS_SELECTED) )
                            {
                                ListView_DeleteItem(hWndList, i);
                                --i;
                            }
                        }
                    }
                    break;


                    case IDC_RB_DELETE_SETS:
                    case IDC_RB_RETAIN_SETS:
                    {
                        switch (LOWORD(wParam))
                        {
                            case IDC_RB_DELETE_SETS:
                            {
                                filter->m_options.m_selectionDeletionMode = hctPruneTypesOptions::HK_SELECTION_DELETE_SELECTED;
                                break;
                            }
                            case IDC_RB_RETAIN_SETS:
                            {
                                filter->m_options.m_selectionDeletionMode = hctPruneTypesOptions::HK_SELECTION_DELETE_NOT_SELECTED;
                                break;
                            }
                        }
                    }

                    default:
                        break;
                }

                // Sync the data with the controls
                filter->setDataFromControls();
            }
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}


HWND hctPruneTypesFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
        hideOptions();

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_PRUNE_TYPES_DIALOG),
        owner, hkPruneTypesFilterDialogProc, (LPARAM) this );

    return m_optionsDialog;
}


void hctPruneTypesFilter::hideOptions()
{
    setDataFromControls();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
