// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterAsset/hctFilterAsset.h>
#include <ContentTools/Common/Filters/FilterAsset/MergeAsset/hctMergeAssetFilter.h>

#include <Common/Base/Container/String/hkUtf8.h>

#include <shlwapi.h>

extern HINSTANCE hInstance;

void hctMergeAssetFilter::setDataFromControls()
{
    hkStringPtr str;
    hctGetDlgItemHkStringPtr(m_optionsDialog, IDC_EDIT_FILENAME, str);
    m_filename = str;
    m_options.m_filename = (char*) m_filename.cString();
}

void hctMergeAssetFilter::setControlsFromData()
{
    m_fillingControls = true;
    {
        if (!m_doNotRefreshEdit)
        {
            SetDlgItemTextW(m_optionsDialog, IDC_EDIT_FILENAME, hkUtf8::WideFromUtf8(m_filename.cString()));
        }
    }
    m_fillingControls = false;
}


INT_PTR CALLBACK hkMergeAssetFilterDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctMergeAssetFilter* filter = reinterpret_cast<hctMergeAssetFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
        {
            filter = (hctMergeAssetFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            filter->m_optionsDialog = hWnd;

            // Init options
            filter->setControlsFromData();

            // Initialize Tool Tips
            {
                CreateToolTip(IDC_EDIT_FILENAME, hWnd, hInstance, "Select an HKX file to merge its contents with the current asset. This is useful for example if you are exporting a rag doll and would like test it's behavior in some already exported landscape. The path to a HKX file which is to be merged should be specified in the filter options.");
            }

            return TRUE; // did handle it
        }
        case WM_COMMAND: // UI Changes
        {
            if (!filter->m_fillingControls)
            {
                if (LOWORD(wParam)==IDC_EDIT_FILENAME)
                {
                    filter->m_doNotRefreshEdit = true;
                }
                filter->setDataFromControls();
                filter->m_doNotRefreshEdit = false;
            }

            switch (LOWORD(wParam))
            {
                case IDC_BROWSE_FILENAME:
                {
                    hkStringPtr str;
                    wchar_t filename[2048];
                    filename[0] = '\0';

                    // Get the filename from the edit control.
                    if ( hctGetDlgItemHkStringPtr(hWnd, IDC_EDIT_FILENAME, str) )
                    {
                        filter->m_filename = str;
                        filter->m_filename = filter->m_filename.replace( '/', '\\' );

                        // Check whether m_filename is relative or not.
                        if( PathIsRelativeW( hkUtf8::WideFromUtf8(filter->m_filename.cString()) ) )
                        {
                            // It's relative to the asset, so append the asset path in order to open the dialog in the correct location.
                            hkStringOld fullFileName = filter->m_assetFolder + filter->m_filename;
                            wcsncpy( filename, hkUtf8::WideFromUtf8(fullFileName.cString()), 2048);
                        }
                        else
                        {
                            // It's absolute, so copy it back into the filename buffer as is (to update any '/'->'\' changes).
                            wcsncpy( filename, hkUtf8::WideFromUtf8(filter->m_filename.cString()), 2048);
                        }
                    }

                    OPENFILENAMEW op;
                    hkString::memSet( &op, 0, sizeof(OPENFILENAMEW) );
                    op.lStructSize = sizeof(OPENFILENAMEW);
                    op.hwndOwner = hWnd;
                    op.lpstrFilter = hctFilterUtils::s_DialogFileExtensions;

                    hkUtf8::WideFromUtf8 assetFolderWide(filter->m_assetFolder.cString());

                    if ( PathIsRootW( filename ) )
                    {
                        op.lpstrInitialDir = filename;
                    }
                    else
                    {
                        op.lpstrInitialDir = assetFolderWide;
                        op.lpstrFile = filename;
                    }
                    op.lpstrDefExt = L"hkx";
                    op.nFilterIndex = 1;
                    op.nMaxFile = 2048;
                    op.Flags = OFN_ENABLESIZING | OFN_EXPLORER | OFN_PATHMUSTEXIST;
                    if ( GetOpenFileNameW(&op) )
                    {
                        hctFilterUtils::getReducedFilename( op.lpstrFile, filter->m_assetFolder, filter->m_filename );
                        SetDlgItemTextW(hWnd, IDC_EDIT_FILENAME, hkUtf8::WideFromUtf8(filter->m_filename.cString()) );
                    }
                }
            }
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}


HWND hctMergeAssetFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
    {
        hideOptions();
    }

    // Try to guess where is the "main" folder for the asset, from the environment or scene data objects
    hctFilterUtils::getAssetFolder(*getFilterManager()->getOriginalContents(), m_assetFolder);

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_MERGE_ASSET_DIALOG), owner, hkMergeAssetFilterDialogProc, (LPARAM) this );

    return m_optionsDialog;
}


void hctMergeAssetFilter::hideOptions()
{
    setDataFromControls();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
