// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

#include <ContentTools/Common/Filters/Common/Filter/hctFilterInterface.h>
#include <ContentTools/Common/Filters/Common/Filter/hctFilterDescriptor.h>

#include <ContentTools/Common/Filters/FilterAsset/MergeAsset/hctMergeAssetOptions.h>

class hctMergeAssetFilter : public hctFilterInterface
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctMergeAssetFilter(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctMergeAssetFilter();

        /*virtual*/ void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        /*virtual*/ void process( class hkRootLevelContainer& data );

        /*virtual*/ void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;
        /*virtual*/ void hideOptions();

    // Public for the dialog
    public:

        HWND m_optionsDialog;
        hkBool m_fillingControls; // True when we are setting up the data in the controls; avoids recursion
        hkBool m_doNotRefreshEdit; // To avoid the edit box being updated constantly and cursor being lost

        hctMergeAssetOptions m_options;
        hkStringOld m_filename;

        // The path to the asset
        hkStringOld m_assetFolder;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;
        hkStringOld m_customClasses;    // to store the list of custom class types

        // Dialog handling stuff
        void setControlsFromData();
        void setDataFromControls();

    private:

        void mergeEnvironment (class hkxEnvironment& masterEnvironment, const class hkxEnvironment& environment);
#ifdef HK_FEATURE_PRODUCT_ANIMATION
        void mergeAnimationContainer (class hkaAnimationContainer& masterAnimationContainer, const class hkaAnimationContainer& animationContainer);
#endif
        void mergeScene (class hkxScene& masterScene, const class hkxScene& scene);
#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
        void mergePhysicsData (class hkpPhysicsData& masterPhysicsData, const class hkpPhysicsData& physicsData);
#endif
};

class hctMergeAssetFilterDesc : public hctFilterDescriptor
{
    public:

        /*virtual*/ unsigned int getID() const { return 0xb4cd9711; }
        /*virtual*/ FilterCategory getCategory() const { return HK_CATEGORY_CORE; }
        /*virtual*/ FilterBehaviour getFilterBehaviour() const { return HK_DATA_MUTATES_INPLACE; }
        /*virtual*/ const char* getShortName() const { return "Merge Asset"; }
        /*virtual*/ const char* getLongName() const { return "Merges an external asset"; }
        /*virtual*/ unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,0,0); }
        /*virtual*/ hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctMergeAssetFilter(owner); }
        /*virtual*/ HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctMergeAssetFilterDesc g_mergeAssetDesc;

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
