// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterAsset/hctFilterAsset.h>
#include <ContentTools/Common/Filters/FilterAsset/MergeAsset/hctMergeAssetFilter.h>

#ifdef HK_FEATURE_PRODUCT_ANIMATION
#include <Animation/Animation/hkaAnimationContainer.h>
#endif

#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#endif

#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Camera/hkxCamera.h>
#include <Common/SceneData/Light/hkxLight.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Skin/hkxSkinBinding.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>
#include <Common/SceneData/Selection/hkxNodeSelectionSet.h>

#include <Common/SceneData/Environment/hkxEnvironment.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <Common/Base/Serialize/Resource/hkResource.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.asset.merge"
#include <Common/Base/System/Log/hkLog.hxx>


hctMergeAssetFilterDesc g_mergeAssetDesc;

hctMergeAssetFilter::hctMergeAssetFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL), m_fillingControls (false), m_doNotRefreshEdit (false)
{
    m_options.m_filename = HK_NULL;
}

hctMergeAssetFilter::~hctMergeAssetFilter()
{
}

template< typename T >
void _mergeSimpleArrays( T*& masterArray, int& numMaster,
                         T* otherArray, int numOther)
{
    if (!masterArray) masterArray = otherArray;
    else if (!otherArray) return;

    // have stuff in both, have to reallocate the master array
    int totalElems = numMaster + numOther;
    T* newData = hkAllocateChunk<T>(totalElems, HK_MEMORY_CLASS_EXPORT);

    hkString::memCpy( newData, masterArray, numMaster*sizeof(T) );
    hkString::memCpy( newData + numMaster, otherArray, numOther*sizeof(T) );
    masterArray = newData;
    numMaster = totalElems;
}

#ifdef HK_FEATURE_PRODUCT_ANIMATION
void hctMergeAssetFilter::mergeAnimationContainer (class hkaAnimationContainer& master, const class hkaAnimationContainer& other)
{
    master.m_skeletons.insertAt(master.m_skeletons.getSize(), other.m_skeletons.begin(), other.m_skeletons.getSize());
    master.m_animations.insertAt(master.m_animations.getSize(), other.m_animations.begin(), other.m_animations.getSize());
    master.m_bindings.insertAt(master.m_bindings.getSize(), other.m_bindings.begin(), other.m_bindings.getSize());
    master.m_attachments.insertAt(master.m_attachments.getSize(), other.m_attachments.begin(), other.m_attachments.getSize());
    master.m_skins.insertAt(master.m_skins.getSize(), other.m_skins.begin(), other.m_skins.getSize());
}
#endif

void hctMergeAssetFilter::mergeScene (class hkxScene& master, const class hkxScene& other)
{
    if (other.m_sceneLength > master.m_sceneLength) master.m_sceneLength = other.m_sceneLength;

    if (other.m_rootNode)
    {
        if (!master.m_rootNode)
        {
            master.m_rootNode = other.m_rootNode;
        }
        else // two root nodes.. add children in as root (root never animated etc anyway)
        {
            master.m_rootNode->m_children.append( other.m_rootNode->m_children.begin(), other.m_rootNode->m_children.getSize() );
        }
    }

    if ( other.m_cameras.getSize())
    {
        master.m_cameras.append( other.m_cameras.begin(), other.m_cameras.getSize() );
    }

    if ( other.m_lights.getSize())
    {
        master.m_lights.append( other.m_lights.begin(), other.m_lights.getSize() );
    }

    if ( other.m_meshes.getSize())
    {
        master.m_meshes.append( other.m_meshes.begin(), other.m_meshes.getSize() );
    }

    if ( other.m_materials.getSize())
    {
        master.m_materials.append( other.m_materials.begin(), other.m_materials.getSize() );
    }

    if ( other.m_inplaceTextures.getSize())
    {
        master.m_inplaceTextures.append( other.m_inplaceTextures.begin(), other.m_inplaceTextures.getSize() );
    }

    if ( other.m_externalTextures.getSize())
    {
        master.m_externalTextures.append( other.m_externalTextures.begin(), other.m_externalTextures.getSize() );
    }

    if ( other.m_skinBindings.getSize())
    {
        master.m_skinBindings.append( other.m_skinBindings.begin(), other.m_skinBindings.getSize() );
    }
}

#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
void hctMergeAssetFilter::mergePhysicsData (class hkpPhysicsData& master, const class hkpPhysicsData& other)
{
    for (int s=0; s<other.getPhysicsSystems().getSize(); s++)
    {
        master.addPhysicsSystem(other.getPhysicsSystems()[s]);
    }
}
#endif

void hctMergeAssetFilter::mergeEnvironment (class hkxEnvironment& master, const class hkxEnvironment& other)
{
    for (int v=0; v<other.getNumVariables(); v++)
    {
        const char* name = other.getVariableName(v);
        const char* value = other.getVariableValue(v);

        // We don't want to override new values - we only set non-existing variables
        if (master.getVariableValue(name)==HK_NULL)
        {
            master.setVariable(name, value);
        }
    }
}


void hctMergeAssetFilter::process( hkRootLevelContainer& data  )
{
    // EXP-1164 : Replace environment variables
    hkStringOld fullFileName (m_options.m_filename);
    {
        // Find the environment in the root level container
        hkxEnvironment tempEnvironment;
        hkxEnvironment* environmentPtr = HK_NULL;
        bool prunedEnvironment = false;
        {
            environmentPtr = data.findObject<hkxEnvironment>();

            // If no environemnt is found, use a temporary one
            if (!environmentPtr)
            {
                prunedEnvironment = true;
                environmentPtr = &tempEnvironment;

                // If we have a scene, fill the environment with ti
                hkxScene* scenePtr = data.findObject<hkxScene>();
                if (scenePtr)
                {
                    hkxSceneUtils::fillEnvironmentFromScene(*scenePtr, tempEnvironment);
                }
            }
        }

        // Substitute
        hkStringOld userFilename;
        const bool substitutionOk = hctFilterUtils::replaceVariables(*environmentPtr, m_options.m_filename, userFilename, true );

        if (!substitutionOk && prunedEnvironment)
        {
            HK_WARN_ALWAYS(0xabba9a9f, "No environment data (required for variable substitutions) found - possibly pruned.");
        }

        // Construct the full filename if the path seems to be relative
        hctFilterUtils::getFullPath(data, userFilename.cString(), fullFileName);
    }


    // Open the stream
    hkIfstream fileIn(fullFileName.cString());

    if (!fileIn.isOk())
    {
        HK_WARN_ALWAYS(0xabbacad4, "Unable to load file " << fullFileName.cString());
        return;
    }

    hkSerializeUtil::ErrorDetails err;
    hkResource* resource = hkSerializeUtil::load(fileIn.getStreamReader(), &err);
    if( !resource )
    {
        HK_WARN_ALWAYS(0xabbad944, err.defaultMessage.cString());
        return;
    }
    hkRootLevelContainer* contentsToMerge = resource->getContents<hkRootLevelContainer>();

    if (!contentsToMerge)
    {
        HK_WARN_ALWAYS(0xabba88de, "No root level containter found in " << fullFileName.cString());
        return;
    }

    Log_Info( "Merging contents of {}...", fullFileName.cString() );

    // We go through each named variant in the file and merge it / add it
    for (int i=0; i<contentsToMerge->m_namedVariants.getSize(); i++)
    {
        const hkRootLevelContainer::NamedVariant& namedVariant = contentsToMerge->m_namedVariants[i];

        // hkxScene
        if( const hkxScene* other = namedVariant.isA<hkxScene>() )
        {
            if( hkxScene* master = data.findObject<hkxScene>() )
            {
                mergeScene(*master, *other);

                Log_Info( "Merged scene data." );
                // Once it's merged we are sorted
                continue;
            }
        }
        else

#ifdef HK_FEATURE_PRODUCT_ANIMATION
        // hkaAnimationContainer
        if( const hkaAnimationContainer* otherAnimationContainer = namedVariant.isA<hkaAnimationContainer>() )
        {
            if( hkaAnimationContainer* master = data.findObject<hkaAnimationContainer>() )
            {
                mergeAnimationContainer(*master, *otherAnimationContainer);

                // Once it's merged we are sorted
                Log_Info( "Merged animation container." );
                continue;
            }
        }
        else
#endif

#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
        // hkpPhysicsData
        if( const hkpPhysicsData* otherPhysicsData = namedVariant.isA<hkpPhysicsData>() )
        {
            if( hkpPhysicsData* master = data.findObject<hkpPhysicsData>() )
            {
                mergePhysicsData(*master, *otherPhysicsData);

                // Once it's merged we are sorted
                Log_Info( "Merged physics data." );
                continue;
            }
        }
        else
#endif

        // hkxEnvironment
        if( const hkxEnvironment* otherEnv = namedVariant.isA<hkxEnvironment>() )
        {
            if( hkxEnvironment* master = data.findObject<hkxEnvironment>() )
            {
                mergeEnvironment(*master, *otherEnv);

                // Once it's merged we are sorted
                Log_Info( "Merged environment." );
                continue;
            }
        }

        // We couldn't merge, so we just add it (just this one)
        data.m_namedVariants.expandOne() = contentsToMerge->m_namedVariants[i];

        Log_Info( "Adding {} ({})", namedVariant.getName(), namedVariant.getTypeName() );

    }
}

void hctMergeAssetFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctMergeAssetOptions* options = hctFilterUtils::getNativeOptions<hctMergeAssetOptions>(optVar))
    {
        m_filename = options->m_filename;
        m_options = *options;
        delete options;
    }
}

void hctMergeAssetFilter::getOptions(hkReflect::Any& buffer) const
{
    hctMergeAssetOptions options( m_options );
    options.m_filename = const_cast<char*>( m_filename.cString() );
    buffer.setFromObj( options );
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
