// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>

class hkMemoryRouter;
class hctFilterDescriptor;


    /// Each DLL (filters and filter manager) contains an instance of this class.
    /// It handles the setup of shared singletons, versioning and initialization.
class hctBaseDll
{
        // IMPORTANT : All virtual methods must remain virtual
        // The reason for that is that their implementation must remain in the DLL in question rather than in the caller.

    public:

            /// Constructor. Takes an HMODULE as parameter: this is the value returned by the Windows call LoadLibrary()
        hctBaseDll (HMODULE dllModule);

            /// Returns the DLL module that was passed on construction.
        virtual HMODULE getDllModule () const;

            /// Returns the version of this DLL. Used to version changes in DLL interfaces.
        virtual unsigned int getDllVersion () const;

            /// Initializes the DLL with the singletons stored in "baseSystemInfo" - this forces the DLL to use those singletons
            /// instead of DLL-specific ones.
        virtual void initDll ( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream );

            /// Should be called whenever a new thread is created - it ensures the static thread DLL in the DLL is updated.
        virtual void initThread ( hkMemoryRouter* m_memoryRouter );

            /// Should be called before unloading the DLL - it calls hkBaseSystem::quit().
        virtual void quitDll ();

        virtual bool isInitialized();

            /// This static, non-virtual method returns the current version at compile time
        static unsigned int getCurrentDllVersion ();

    protected:

        HMODULE m_dllModule;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
